/* Interface to TLLDelegate class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLLDelegate.h,v 1.1 1998/01/08 16:13:21 tiggr Exp $  */

#import "TLDictionary.h"
#import "TLSymbol.h"
#import "config.h"

@interface TLLDelegate: TLObject
{
  /* A mapping from delegate selectors to lambda expressions or functions to
     be invoked.  */
  TLDictionary *methods;

  /* The method implementation to be invoked.  Used for communication
     between forward and delegateForward.  XXX *single-threaded* force.  */
  id imp;
}

/* Return a new delegate object.  */
+(TLLDelegate *) delegate;

/* Return a new delegate object and set it as O's delegate.  */
+(TLLDelegate *) delegateForObject: o;

-addMethod: (TLSymbol *) name implementation: imp;

-methods;

-(retval_t) forward: (SEL) sel : (FORWARD_ARGUMENTS) arg_frame;
-(BOOL) respondsTo: (SEL) sel;

@end

/* Make sure these methods are known.  */
@interface TLLDelegate (NotImplemented)

-setDelegate: o;
-delegate;

@end
