/* Interface to TLFDStream class.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: TLFDStream.h,v 1.1 1998/01/08 16:13:14 tiggr Exp $  */

#import "TLStream.h"
#import "TLString.h"

@interface TLFDStream: TLObject <TLStream, TLMutableStream>
{
  int fd;
}

+(id <TLSeekableStream, TLInputStream>) streamWithFD: (int) an_fd;
+(id <TLSeekableStream, TLMutableStream>) mutableStreamWithFD: (int) an_fd;

+(id <TLSeekableStream, TLInputStream>) streamWithFileNamed: (id <TLString>) n;
+(id <TLSeekableStream, TLMutableStream>) mutableStreamWithFileNamed:
  (id <TLString>) name;
+(id <TLSeekableStream, TLMutableStream>)
  mutableStreamWithFileNamed: (id <TLString>) name
			mode: (int) mode protection: (int) prot;

-initWithFD: (int) an_fd;

#ifdef TLFDSTREAM_DECLARE_PRIVATE_METHODS

/* Compare two FD streams, ordering on file descriptor.
   XXX Questionable semantics.  */
-(int) compare: (id) o;

#endif

@end
