/* TLL initialization.
   This file is part of TL, Tiggr's Library.
   Written by Tiggr <tiggr@es.ele.tue.nl>
   Copyright (C) 1995, 1996 Pieter J. Schoenmakers
   TL is distributed WITHOUT ANY WARRANTY.
   See the file LICENSE in the TL distribution for details.

   $Id: init.m,v 1.1 1998/01/08 16:12:14 tiggr Exp $  */

#import "tl/tl.h"

/* Having this common causes a weird problem on 3.2 NEXTSTEP.  */
TLNumber **tll_small_int = 0;

id CO_TLCons, CO_TLString, CO_TLNumber, CO_TLSymbol, CO_TLVector;
id CO_TLMutableString;

void
tl_init (void)
{
  static int initialized = 0;
  int i;

  /* We will do this only once.  */
  if (initialized)
    return;
  initialized = 1;

#ifdef PATCH_387_CW
  {
    volatile short cw;

    __asm__ volatile ("fstcw (%0)" : : "g" (&cw));
    cw |= 1;			/* Mask the `invalid' exception.  */
    __asm__ volatile ("fldcw (%0)" : : "g" (&cw));
  }
#endif

#if GNU_RUNTIME
  /* Get Objective-C linking semantics.  */
  {
    extern void tl (void *);
    tl (0);
  }
#endif

  CO_TLCons = objc_get_class ("TLCons");
  CO_TLString = objc_get_class ("TLString");
  CO_TLMutableString = objc_get_class ("TLMutableString");
  CO_TLNumber = objc_get_class ("TLNumber");
  CO_TLVector = objc_get_class ("TLVector");
  CO_TLSymbol = objc_get_class ("TLSymbol");

  /* Have TLSymbol initialize before any class posing is done!  */
  {
    extern void tlsymbol_save_class_list (void);
    tlsymbol_save_class_list ();
  }

  /* XXX This should be generated code.  */
  [TLPatchObject init];
#if HAVE_PATCHNSOBJECT
  [TLPatchNSObject init];
#endif

  [TLObject init];
  /* Get some stdio streams going.  */
  [TLFILEStream init];

  /* Initialize the small integers from TL_SMALL_INT_MIN to
     TL_SMALL_INT_MAX, inclusive.  */
  tll_small_int = xmalloc ((1 + TL_SMALL_INT_MAX - TL_SMALL_INT_MIN)
			   * sizeof (*tll_small_int));
  tll_small_int -= TL_SMALL_INT_MIN;
  for (i = TL_SMALL_INT_MIN; i <= TL_SMALL_INT_MAX; i++)
    {
      tll_small_int[i] = [TLNumber numberWithInt: i];
      [tll_small_int[i] gcLock];
    }

  /* Force TLCons to initialize itself.  This is important for any class
     invoking the CONS() macro.  */
  [TLCons self];

  [TLFILEStream self];
  [TLSymbol self];
  [TLLSubroutine self];
  tll_subr_init ();
  [TLLLambda self];
  [TLLTag self];

#if 0
#if DEBUG_GC > 0
  {
    int i;

    for (i = 0; i < 2; i++)
      [TLObject gc];
  }
#endif
#endif
}
