/* Interface to ltt unit file handling.  -*- objc -*-
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: unit.h,v 1.13 1998/01/05 00:58:31 tiggr Exp $  */

@class LTTUnit, LTTFile;

@protocol LTTUnitAcceptor

/* Each of the methods may return a new value for the current acceptor.
   If a new value is not desired, SELF should be returned.  */

/* Start the unit named NAME.  */
-(id <LTTUnitAcceptor>) startUnitNamed: (id <TLString>) name;

/* Note that this unit uses the unit named NAME.  */
-(id <LTTUnitAcceptor>) usesUnit: (id <TLString>) name;

/* Register the class named NAME to be found in the file named FILENAME.
   If FILENAME is NIL, it should be interpreted to be equal to the name of
   the class.  */
-(id <LTTUnitAcceptor>) class: (id <TLString>) name
		       inFile: (id <TLString>) filename
		       posing: (TLCons *) posing;

/* Register the extension named NAME to be found in the file named
   FILENAME, extending the class BASE from the unit UNIT_NAME.  If the
   UNIT_NAME is NIL, all units match (probably resulting in an error due
   to ambiguity).  If FILENAME is NIL, it should be interpreted to be
   equal to the name of the extension.  */
-(id <LTTUnitAcceptor>) extension: (id <TLString>) name
			   inFile: (id <TLString>) filename
			  ofClass: (id <TLString>) base
			   inUnit: (id <TLString>) unit_name
			   posing: (TLCons *) posing;

/* End the current unit.  */
-(id <LTTUnitAcceptor>) endUnit;

@end

/* The current acceptor, i.e. the object fed what we find.  */
extern id <LTTUnitAcceptor> current_acceptor;

/* Search for the UNIT along the PATH and feed the unit to the ACCEPTOR.
   Return in FILENAME the name of the file read.  Return 0 upon success,
   -1 otherwise.  */
int load_unit (id <TLString> name, TLVector *path, id <TLString> gendir,
	       id <LTTUnitAcceptor> acceptor, TLString **filename);

/* Find and return the unit named NAME.  This is the only acceptable way
   to do a top-level search for a unit, as it patches the posing stuff.  */
LTTUnit *ltt_find_unit (id <TLString> name);

/* Read the unit FILE named NAME and feed the definitions to the ACCEPTOR.
   Return 0 upon success, -1 otherwise.  */
int read_unit (FILE *file, id <TLString> name,
	       id <LTTUnitAcceptor> acceptor);

#ifdef ltt
/* Some definitions private to `lunit.l' and `punit.y'.  */

/* Great.  There is no place where we can declare this with its prototype.  */
extern int ltt_lex ();

/* The parser.  */
int ltt_parse (void);

/* The function which sets up the lexer for the file F, and then invokes
   the parser.  */
void ltt_parse_unit (FILE *f);

#undef YY_DECL
#define YY_DECL int ltt_lex (YYSTYPE *lvalp)

#endif
