/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: LTTVariable.m,v 1.5 1998/01/05 00:58:23 tiggr Exp $  */

#define LTTVARIABLE_DECLARE_PRIVATE_METHODS
#import "LTTVariable.h"
#import "ltt.h"

@implementation LTTVariable

+(LTTVariable *) variableWithName: (id <TLString>) n
			extension: (LTTExtension *) e
{
  return [[self gcAlloc] initWithName: n extension: e];
} /* +variableWithName:extension: */

-(LTTExtension *) extension
{
  return extension;
} /* -extension */

-(void) gcReference
{
  MARK (extension);
  MARK (type);

  [super gcReference];
} /* -gcReference */

-(id) initWithName: (TLString *) n extension: (LTTExtension *) e
{
  if (![super initWithName: [CO_LTTName nameWithInternal: n]])
    return nil;

  extension = e;

  return self;
} /* -initWithName:extension: */

-(void) setType: (id) t
{
  ASGN_IVAR (type, t);
} /* -setType: */

-(id) type
{
  return type;
} /* -type */

@end
