<copyright> C Std class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1995, 1996 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Std.t,v 1.9 1998/03/15 01:04:18 tiggr Exp $</id>  </copyright>

<c>
#include <stdlib.h>
#include <tom/util.h>
</c>

<doc> This class contains a bunch of functions from `stdio.h', `stdlib.h',
    and other such ANSI C headers.  </doc>
implementation class Std

<doc> Immediately abort execution of the program, causing a core dump on
    some systems.  </doc>
extern void
  abort;

<doc> Suspend execution for {seconds} seconds.  </doc>
extern void
  sleep int seconds;

int (result)
  system String cmdline
{
<c>
  {
    DECL_USEL (tom, _pi__byteStringContents);
    tom_int len;
    char *s;

    C_STRING_WITH_TOM_STRING (s, len, cmdline);
    result = system (s);
  }
</c>
}

end;

implementation instance Std
end;
