#
# Tcl Library for tkCVS
#

#
# $Id: import.tcl,v 1.15.2.18 1999/10/27 07:11:01 dorothyr Exp $
#
# Adds a new document to the repository.
#

proc import_setup {} {
  global cvsglb

  # Give it a default
  set cvsglb(newvers) 1

  toplevel .import
  frame .import.top -relief groove -border 2
  frame .import.center
  frame .import.center.left
  frame .import.center.right
  frame .import.down -relief groove -border 2

  # When packing, I only want the right hand side and the buttons
  # to be interactively strechable (in case the user wants more space
  # to enter long document names).

  pack .import.top -side top -fill x -expand 1
  pack .import.center -side top -fill x -expand 1
  pack .import.down -side bottom -fill x -expand 1

  message .import.top.explain -justify left -aspect 300 -relief groove \
    -text "This will import the current directory and its sub-directories\
          into CVS, creating a new module.

\
          If you are creating a new project which\
          is not under a pre-existing directory in the CVS repository,\
          you may wish to use the \"New Directory\" button to create a\
          directory first.  This will allow the module to\
          appear in the Module Browser.
\ "
  label .import.lnewcode -text "Module Name" -anchor w
  label .import.lnewdir  -text "Module Path" -anchor w
  label .import.lnewdesc -text "Descriptive Name" -anchor w
  label .import.lnewvers  -text "Version Number" -anchor w

  entry .import.tnewcode -relief sunken -textvariable cvsglb(newcode) -width 40
  entry .import.tnewdir -relief sunken -textvariable cvsglb(newdir) -width 40
  entry .import.tnewdesc -relief sunken -textvariable cvsglb(newdesc) -width 40
  entry .import.tnewvers -relief sunken -textvariable cvsglb(newvers) -width 40

  pack .import.center.left -side left -fill y
  pack .import.center.right -side left -fill both -expand 1

  pack .import.top.explain -side top -padx 2 -pady 2 -fill x -expand 1
  pack .import.lnewcode .import.lnewdir \
       .import.lnewdesc .import.lnewvers \
    -in .import.center.left \
    -side top -fill x -pady 3

  pack .import.tnewcode .import.tnewdir \
       .import.tnewdesc .import.tnewvers \
    -in .import.center.right \
    -side top -fill both -expand 1 -pady 3

  button .import.ok -text "OK" \
    -command do_import
  button .import.newdir -text "New Directory" \
    -command inewdir_run
  button .import.quit -text "Quit" \
    -command { wm withdraw .import }

  pack .import.ok .import.newdir .import.quit -in .import.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  wm withdraw .import
  wm title .import "Import a New Module"
  wm minsize .import 1 1

  toplevel .inewdir
  frame .inewdir.left
  frame .inewdir.right
  frame .inewdir.down -relief groove -border 2

  # When packing, I only want the right hand side and the buttons
  # to be interactively strechable (in case the user wants more space
  # to enter long document names).

  pack .inewdir.down -side bottom -fill x -expand 1
  pack .inewdir.left -side left -fill y
  pack .inewdir.right -side left -fill both -expand 1

  label .inewdir.lnewdir  -text "New Directory Location" -anchor w
  label .inewdir.lnewdesc -text "New Directory Name" -anchor w

  entry .inewdir.tnewdir -relief sunken -width 40 \
    -textvariable cvsglb(dnewdir)
  entry .inewdir.tnewdesc -relief sunken -width 40 \
    -textvariable cvsglb(dnewdesc)


  pack .inewdir.lnewdir .inewdir.lnewdesc \
    -in .inewdir.left \
    -side top -fill x -pady 3

  pack .inewdir.tnewdir .inewdir.tnewdesc \
    -in .inewdir.right \
    -side top -fill both -expand 1 -pady 3

  button .inewdir.ok -text "OK" \
    -command do_inewdir
  button .inewdir.quit -text "Quit" \
    -command { wm withdraw .inewdir }

  pack .inewdir.ok .inewdir.quit -in .inewdir.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1

  wm withdraw .inewdir
  wm title .inewdir "Import a New Directory"
  wm minsize .inewdir 1 1
}

proc import_run {} {
  global cvsglb
  global cvscfg
  global cwd

  if {$cvscfg(cvsver) < 1.3} {
    set mess "This function is not available in CVS version $cvscfg(cvsver)."
    append mess "\n\nPlease upgrade your CVS to version 1.3 or later"
    append mess " or use Add instead."
    cvsok $mess
    return 1
  }

  set cvsglb(newcode) [file tail $cwd]
  wm deiconify .import
  raise .import
}

proc inewdir_run {} {
  global cvscfg

  if {$cvscfg(remote)} {
    cvs_remote_bad
    return 1
  }

  wm deiconify .inewdir
  raise .inewdir
}

proc append_modules_file { puts_lines } {
  global cvs
  global cvsglb
  global cvscfg

  if { $cvscfg(cvs-modfile) == "true" } {
    cd
    catch {exec $cvs -d $cvscfg(cvsroot) checkout modules}
    cd modules
    set modfile [open modules a]
    foreach puts_line $puts_lines {
      puts $modfile $puts_line
    }
    close $modfile
    catch {exec $cvs -d $cvscfg(cvsroot) ci -m "added $cvsglb(newcode)" modules}
  } else {
    # cvscfg(modfile) should be valid here,
    # so we use the name determined by proc 'get_modules_file'
    if { $cvscfg(remote) == 1 } {
      # again get a copy
      get_remote_copy_modules_file
    }
    # append
    set modfile [open $cvscfg(modfile) a]
    foreach puts_line $puts_lines {
      puts $modfile $puts_line
    }
    close $modfile
    if { $cvscfg(remote) == 1 } {
      # write back
      put_remote_copy_modules_file
    }
  }
}

proc do_import {} {
  global cvs
  global cvsglb
  global cvscfg
  global cwd
  global incvs
  global dtitle
  global dcontents
  global location
  global feedback

  #puts "do_import"
  #foreach l [array names location] { puts "location($l): $location($l)" }
  #foreach l [array names dcontents] { puts "dcontents($l): $dcontents($l)"}

  # Error checks
  if {$incvs} {
    cvsok "This directory is already in CVS.\nCan\'t import here!"
    return 1
  }
  if { $cvsglb(newdir) == "" } {
    cvsok "You must type in a directory."
    return 1
  }
  if { $cvsglb(newdesc) == "" } {
    cvsok "You must type in a module name."
    return 1
  }
  if { $cvsglb(newvers) == "" } {
    cvsok "You must type in a version number."
    return 1
  }
  if { $cvsglb(newcode) == "" } {
    cvsok "You must type in a module code."
    return 1
  }

  # Check that all apropriate Directories in newdirname exist
  set cvsglb(newdir) [string trimleft $cvsglb(newdir) "/"]
  set checkdirname [file dirname $cvsglb(newdir)]
  if {$checkdirname != "."} {
    set knowndirs [array names dtitle]
    foreach dc [array names location] {
      lappend knowndirs $location($dc)
    }
    #puts $knowndirs
    if {[lsearch -exact $knowndirs $checkdirname] == -1} {
     cvsok "The upper directory \"$checkdirname\" doesn\'t exist."
     return 1
    }
  }

  set create_module 1
  if [file isdirectory $cvscfg(cvsroot)/$cvsglb(newdir)] {
    set mess "NOTE:  You are importing over a directory that already exists!"
    if {[cvsconfirm $mess] == 0} {
      set create_module 0
    } else {
      return 1
    }
  }

  # Make a baseline tag

  set versions [split $cvsglb(newvers) ".,/ -"]
  set baseline "baseline-[join $versions {_}]"

  feedback_cvs $feedback(cvs) "Importing $cvsglb(newcode), please wait"
  #set retcode [catch {exec \
  #   $cvs -d $cvscfg(cvsroot) import -m "Imported using tkCVS" \
  #        $cvsglb(newdir) VENDOR $baseline} view_this]
  #if $retcode {
  # error $view_this
  #}
  exec_command "CVS Import" \
      "$cvs -d $cvscfg(cvsroot) import -m \"Imported using tkCVS\" \
	    $cvsglb(newdir) VENDOR $baseline"
  feedback_cvs $feedback(cvs) ""
  #view_output "CVS Import" $view_this

  # Update the modules file.
  if {$create_module == 1} {
    exec_command "Checkout New Module" \
        "$cvs -d $cvscfg(cvsroot) checkout CVSROOT/modules"

    cd CVSROOT                            
    set modfile [open modules a]
    puts $modfile "#M\t$cvsglb(newcode)\t$cvsglb(newdesc)"
    puts $modfile "$cvsglb(newcode)\t$cvsglb(newdir)"
    close $modfile
    exec_command "CVS Checkin CVSROOT" \
        "$cvs -d $cvscfg(cvsroot) ci -m \"added $cvsglb(newcode)\" modules"
    cd ../                              
    eval exec "$cvs -Q release -d CVSROOT"
    cd $cwd
  }

  read_modules_setup
  checkout_fill_listbox
  wm withdraw .import
}

proc do_inewdir {} {
  global cvsglb
  global cvs
  global cwd
  global dtitle
  global cvscfg


  # Error checks
  if { $cvsglb(dnewdir) == "" } {
    cvsok "You must type in a directory."
    return 1
  }
  if { $cvsglb(dnewdesc) == "" } {
    cvsok "You must type in a directory name."
    return 1
  }

  # Check that all apropriate Directories in newdirname exist
  set cvsglb(dnewdir) [string trimleft $cvsglb(dnewdir) "/"]
  set checkdirname [file dirname $cvsglb(dnewdir)]
  if {$checkdirname != "."} {
    if {[lsearch -exact [array names dtitle] $checkdirname] == -1} {
     cvsok "The upper directory \"$checkdirname\" doesn\'t exist."
     return 1
    }
  }

  if {[lsearch -exact [array names dtitle] $cvsglb(dnewdir)] >= 0} {
     cvsok "This directory already exists!"
     return 1
  }

  cd
  catch {exec $cvs -d $cvscfg(cvsroot) checkout CVSROOT/modules}
  cd CVSROOT
  set modfile [open modules a]
  puts $modfile ""
  puts $modfile "#D	$cvsglb(dnewdir)\t$cvsglb(dnewdesc)"
  close $modfile
  exec_command "CVS Checkin CVSROOT" \
      "$cvs -d $cvscfg(cvsroot) ci -m \"added $cvsglb(dnewdir)\" modules"
  cd $cwd

  read_modules_setup
  checkout_fill_listbox
}
