@echo off

rem Last modified for SE -0.78

rem --------------------- Installation directory ----------------------

rem You must set below the directory under which you want to install 
:   SmallEiffel. For example: set SE_DIR=C:\SmallEiffel
:   This variable is only used during the installation process.

set SE_DIR=

rem ---------------------- C compiler selection: ----------------------
 
set CC=

rem Choose one of the compilers below, by uncommenting the appropriate 
rem lines.

rem To use gcc (or mingw32), uncomment the next 5 lines :
rem set CC=gcc
rem set CC_OPTIONS=-ansi -O6 -c
rem set OBJ=.o
rem set LD=%CC%
rem set LD_OPTIONS=-ansi -O6
rem set EXE_NAME=-o
rem set LINK_LIB=


rem To use lcc-win32, uncomment the next lines:
rem set CC=lcc
rem set CC_OPTIONS= -O 
rem set OBJ=.obj
rem set LD=lcclnk
rem set LD_OPTIONS= -s
rem set EXE_NAME=-o 
rem set LINK_LIB=

rem To use Watcom C++, uncomment the last 5 lines of this block.
rem The CC_OPTIONS flag corresponds to standard Pentium 
rem optimization. For optimizations more fitted to your 
rem system, read Watcom help
rem set CC=wcl386
rem set CC_OPTIONS=/ox /fp5 -c
rem set OBJ=.obj
rem set LD=%CC%
rem set LD_OPTIONS=/ox /fp5
rem set EXE_NAME=/fe=
rem set LINK_LIB=

rem For Microsof Visual C++ (uncomment next 5 lines) :
rem set CC=cl
rem set CC_OPTIONS=-O2 -nologo -D"WIN32" -c
rem set LD=%CC%
rem set LD_OPTIONS=-O2 -nologo -D"WIN32"
rem set OBJ=.obj
rem set EXE_NAME=-o
rem set LINK_LIB=-lm

rem If you want to use Borland C++, try using the following options
rem settings. Borland C++ 5.0 has a loop strength reduction bug that
rem means you must either use -O-v or use the Intel back end when
rem compiling some SmallEiffel code. The warnings we disable are for
rem variables and parameters not actually used, and for functions which
rem do not return a value.
rem Under Borland C++, when linking an executable the -e option is used
rem instead of -o; furthermore, there can be no space between the option
rem and the argument.

rem Borland with traditional back end (uncomment next 4 lines) :
rem set CC=bcc32
rem set CC_OPTIONS=-5 -w-aus -w-par -w-rvl -O2 -O-v -c
rem set OBJ=.obj
rem set LD=%CC%
rem set LD_OPTIONS=-5 -w-aus -w-par -w-rvl -O2 -O-v 
rem set EXE_NAME=-e
rem set LINK_LIB=-lm

rem Borland with Intel Reference Compiler back end (uncomment next 4 lines) :
rem set CC=bcc32i
rem set CC_OPTIONS=-5 -w-aus -w-par -w-rvl -O2 -c
rem set OBJ=.obj
rem set LD=%CC%
rem set LD_OPTIONS=-5 -w-aus -w-par -w-rvl -O2 
rem set EXE_NAME=-e
rem set LINK_LIB=-lm

rem ------------ Nothing to change after this line ------------------
 
cls
echo INSTALL SmallEiffel script for Windows NT/95
echo.

rem Under Windows 95 we cannot test for existence of directories in batch
rem files and standard utilities support different switches than NT. As a
rem result we follow a different sequence of operations for Win95 than NT.
rem Under Win95 we can use "deltree" instead of "del /f/q" to erase read-
rem only files, but there is no equivalent to "cd /d" and we need to take
rem steps to see if using it will work.

rem Compiling the split versions of compile_to_c should be easily done with
rem a FOR statement which matches compile_to_c?.c and compile_to_c??.c as
rem patterns. However, the Windows 95 command interpreter has a defect where
rem filename patterns in FOR statements are matched only against the short-
rem format 8.3 filenames, making it useless for this purpose. Even worse,
rem the 8.3 filenames are all upper-case, which causes gratuitous changes
rem of the case of results. Instead, we have to manually generate the 
rem indexes.

rem Note also that under Win95, the command processor only treats the first
rem 8 characters of any label as significant in a batch file.

if "%SmallEiffel%~"=="~" goto help_smalleiffel
if "%SE_DIR%~"=="~" goto help_se_dir
if "%CC%~"=="~" goto help_cc

set CLEAN=del /f /q
if exist . goto winnt_clean
set CLEAN=deltree /y
:winnt_clean


if not exist . goto win95_install

echo System appears to be NT rather than Windows 95

if not exist %SE_DIR% goto help_exist
cd /d %SE_DIR%
if errorlevel 1 goto help_cd
if not exist bin mkdir bin
if not exist bin goto help_mkdir_bin

cd bin
echo "dummy" > dummy
del /f /s /q .
cd ..

goto install_common

rem ----------------------------- Windows 95 section
:win95_install

if not exist %SE_DIR%\READ_ME goto help_exist

rem What we do now is try and change to the smalleiffel directory, and then
rem we try and test for the presences of various files (/not/ directories)
rem from our distribution to see that we actually got where we needed. If
rem not, appeal to the user. Thanks to the test above we expect that the
rem SmallEiffel environment variable is set properly.


cd %SE_DIR%
if not exist bin_c\compile.c goto help_drive

echo System appears to be Windows 95 rather than NT

deltree /y bin >nul:
mkdir bin

rem ------------------------------- Common section

:install_common

cd sys
%CLEAN% system.se >nul:
if exist system.se goto help_del_system

rem Note that there is no space before the ">" symbol, which is quite
rem important since otherwise "echo" will write the preceding space to
rem the file and confuse the code which reads the generated files.
echo Windows>system.se

if exist gc.BAK goto after_gc_bak
copy gc gc.BAK
:after_gc_bak
echo windows.c > gc

rem Updating loadpath.Windows :
%CLEAN% loadpath.Windows >nul:
echo .\> loadpath.Windows
echo %SE_DIR%\lib_std\>> loadpath.Windows
echo %SE_DIR%\lib_rand\>> loadpath.Windows
echo %SE_DIR%\lib_show\>> loadpath.Windows
echo %SE_DIR%\lib_se\>> loadpath.Windows
rem ----- compiler.se setting -----

if not exist compiler.se goto set_c_compiler
%CLEAN% compiler.OLD >:nul
copy compiler.se compiler.OLD >:nul
%CLEAN% compiler.se >nul:
:set_c_compiler
if "%CC%"=="lcc" goto set_lcc_win32
echo %CC% > compiler.se
goto c_compiler_set
:set_lcc_win32
echo lcc-win32 > compiler.se
:c_compiler_set

rem ------ C compilations --------

cd ..\bin_c
echo C compiling clean ...
%CLEAN% clean.exe >nul:
%CC% %CC_OPTIONS% clean.c
echo Linking clean ...
%LD% %EXE_NAME%clean.exe %LD_OPTIONS% clean%OBJ%
if not exist clean.exe goto clean_help_cc

echo C compiling finder ...
%CLEAN% finder.exe >nul:
%CC% %CC_OPTIONS% finder.c
echo Linking finder ...
%LD% %EXE_NAME%finder.exe %LD_OPTIONS% finder%OBJ%
if not exist finder.exe goto finder_help_cc

echo C compiling compile ...
%CLEAN% compile.exe >nul:
%CC% %CC_OPTIONS% compile.c
echo Linking compile ...
%LD% %EXE_NAME%compile.exe %LD_OPTIONS% compile%OBJ%
if not exist compile.exe goto compile_help_cc

echo C compiling print_jvm_class ...
%CLEAN% print_jvm_class.exe >nul:
%CC% %CC_OPTIONS% print_jvm_class.c
echo Linking print_jvm_class ...
%LD% %EXE_NAME%print_jvm_class.exe %LD_OPTIONS% print_jvm_class%OBJ%
if not exist print_jvm_class.exe goto print_jvm_class_help_cc


echo C compiling compile_to_c ...
%CLEAN% compile_to_c.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10)          do %CC% %CC_OPTIONS% compile_to_c%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% compile_to_c%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% compile_to_c%%i.c
for %%i in (31 32 33 34 35 36 37 38 39 40) do %CC% %CC_OPTIONS% compile_to_c%%i.c
for %%i in (41 42 43 44 45 46 47 48 49 50) do %CC% %CC_OPTIONS% compile_to_c%%i.c
for %%i in (51 52 53 54 55 56 57)          do %CC% %CC_OPTIONS% compile_to_c%%i.c

echo Linking compile_to_c ...
%LD% %EXE_NAME%compile_to_c.exe %LD_OPTIONS% compile_to_c*%OBJ% %LINK_LIB%
if not exist compile_to_c.exe goto compile_to_c_help_cc
%CLEAN% *%OBJ% >nul:

echo C compiling compile_to_jvm...
%CLEAN% compile_to_jvm.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10)          do %CC% %CC_OPTIONS% compile_to_jvm%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% compile_to_jvm%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% compile_to_jvm%%i.c
for %%i in (31 32 33 34 35 36 37 38 39 40) do %CC% %CC_OPTIONS% compile_to_jvm%%i.c
for %%i in (41 42 43 44 45 46 47 48 49 50 51) do %CC% %CC_OPTIONS% compile_to_jvm%%i.c

echo Linking compile_to_jvm ...
%LD% %EXE_NAME%compile_to_jvm.exe %LD_OPTIONS% compile_to_jvm*%OBJ% %LINK_LIB%
if not exist compile_to_jvm.exe goto compile_to_jvm_help_cc
%CLEAN% *%OBJ% >nul: 

echo C compiling pretty...
%CLEAN% pretty.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10)          do %CC% %CC_OPTIONS% pretty%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% pretty%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% pretty%%i.c
for %%i in (31 32 33 34 35 36 37 38)       do %CC% %CC_OPTIONS% pretty%%i.c

echo Linking pretty ...
%LD% %EXE_NAME%pretty.exe %LD_OPTIONS% pretty*%OBJ% %LINK_LIB%
if not exist pretty.exe goto pretty_help_cc
%CLEAN% *%OBJ% >nul:

echo C compiling short...
%CLEAN% short.exe >nul:
for %%i in (1 2 3 4 5 6 7 8 9 10)          do %CC% %CC_OPTIONS% short%%i.c
for %%i in (11 12 13 14 15 16 17 18 19 20) do %CC% %CC_OPTIONS% short%%i.c
for %%i in (21 22 23 24 25 26 27 28 29 30) do %CC% %CC_OPTIONS% short%%i.c
for %%i in (31 32 33 34 35 36 37)          do %CC% %CC_OPTIONS% short%%i.c

echo Linking short ...
%LD% %EXE_NAME%short.exe %LD_OPTIONS% short*%OBJ% %LINK_LIB%
if not exist short.exe goto short_help_cc
%CLEAN% *%OBJ% >nul:

%CLEAN% %SE_DIR%\bin\*.exe >nul:
%CLEAN% %SE_DIR%\bin_c\*%OBJ% >nul:
move %SE_DIR%\bin_c\*.exe %SE_DIR%\bin >nul:

rem We don't rename the help files, since .hlp works
cd %SE_DIR%

goto end_success


rem ------------------------ help section -----------------------



:help_se_dir
echo You must edit "install.bat" to set variable "SE_DIR" to 
echo the directory in which you want to install SmallEiffel.
goto end_failure

:help_smalleiffel
echo You must set environment variable "SmallEiffel" to point
echo to your "system.se" file. For example, this usually is
echo c:\SmallEiffel\sys\system.se
goto end_failure

:help_cc
echo You must edit "install.bat" to select one of the compilers,
echo which will set correctly the "CC" variable and a few other.
goto end_failure 

:help_exist
echo Directory "%se_dir%" does not exist.
goto help_se_dir
goto end_failure

:help_cd
echo Cannot go to (cd) directory "%SE_DIR%".
goto help_se_dir
goto end_failure

:help_mkdir_bin
echo Cannot create directory "%SE_DIR%\bin".
goto end_failure

:help_del_system
echo Cannot remove file "%SE_DIR%\sys\system.se".
goto end_failure

:clean_help_cc
echo Unable to C compile clean.c to clean.exe.
goto end_cc_error

:pretty_help_cc
echo Unable to C compile pretty.c to pretty.exe.
goto end_cc_error

:short_help_cc
echo Unable to C compile short.c to short.exe.
goto end_cc_error

:finder_help_cc
echo Unable to C compile finder.c to finder.exe.
goto end_cc_error

:compile_help_cc
echo Unable to C compile compile.c to compile.exe.
goto end_cc_error

:print_jvm_class_help_cc
echo Unable to C compile print_jvm_class.c to print_jvm_class.exe.
goto end_cc_error

:compile_to_c_help_cc
echo Unable to C compile compile_to_cXX.c to compile.exe.
goto end_cc_error

:compile_to_jvm_help_cc
echo Unable to C compile compile_to_jvmXX.c to compile.exe.
goto end_cc_error

:compile_help_cc
echo Unable to C compile prettyXX.c to compile.exe.
goto end_cc_error

:help_drive
echo Unable to change to the SmallEiffel directory, possibly
echo because it is on a different drive. Please make the current
echo drive the one for "%SE_DIR%".
goto end_failure


rem ------------------------------------------------------------

:end_cc_error
echo C compiler: %CC%  Options: %CC_OPTIONS%
echo C linker:   %LD%  Options: %LD_OPTIONS%
goto end_failure

:end_success
echo SmallEiffel Install succeeded.
echo Don't forget to add "%SE_DIR%\bin" to your PATH environment variable.
goto end

:end_failure
echo SmallEiffel Install failed.
goto end

:end
pause
