      SUBROUTINE PBCTRADD( ICONTXT, UPLO, FORM, M, N, ALPHA, A, LDA,
     $                     BETA, B, LDB, MINT, NINT, MEN, NEN )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     .. Scalar Arguments ..
      CHARACTER          FORM, UPLO
      INTEGER            ICONTXT, LDA, LDB, M, MEN, MINT, N, NEN, NINT
      COMPLEX            ALPHA, BETA
*     ..
*     .. Array Arguments ..
      COMPLEX            A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PCTRADD copies part of an upper (or lower) triangular matrix A
*  to another matrix B:
*                       B <== alpha * A + beta * B
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            I, J, JP, JX, MM, MX
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           PBCMATADD, PBCVECADD
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, REAL
*     ..
*     .. Executable Statements ..
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is upper triangular (triangular part is at the bottom)
*
            MM = M
            JP = 0
            DO 20 I = 1, ICEIL( NEN, NINT )
               DO 10 J = 1, MIN( N, NEN-JP )
                  JX = JP + J
                  CALL PBCVECADD( ICONTXT, 'G', MM+J, ALPHA, A( 1, JX ),
     $                            1, BETA, B( 1, JX ), 1 )
   10          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   20       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is upper triangular Hermitian
*
            MM = M
            JP = 0
            DO 40 I = 1, ICEIL( NEN, NINT )
               DO 30 J = 1, MIN( N, NEN-JP )
                  JX = JP + J
                  CALL PBCVECADD( ICONTXT, 'G', MM+J-1, ALPHA,
     $                            A( 1, JX ), 1, BETA, B( 1, JX ), 1 )
                  B( MM+J, JX ) = REAL( BETA ) * REAL( B( MM+J, JX ) ) +
     $                            REAL( ALPHA )* REAL( A( MM+J, JX ) )
   30          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   40       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M
            JP = 1
            DO 50 I = 1, ICEIL( NEN, NINT )
               CALL PBCMATADD( ICONTXT, 'G', MM, MIN( N, NEN-JP+1 ),
     $                         ALPHA, A( 1, JP ), LDA, BETA, B( 1, JP ),
     $                         LDB )
               MM = MM + MINT
               JP = JP + NINT
   50       CONTINUE
         END IF
*
      ELSE
*
         IF( LSAME( FORM, 'T' ) ) THEN
*
*           A is lower triangular (triangular part is at the top)
*
            MM = M
            JP = 0
            DO 70 I = 1, ICEIL( NEN, NINT )
               DO 60 J = 1, MIN( N, NEN-JP )
                  MX = MM + J
                  JX = JP + J
                  IF( MX.LE.MEN )
     $               CALL PBCVECADD( ICONTXT, 'G', MEN-MX+1, ALPHA,
     $                               A( MX, JX ), 1, BETA, B( MX, JX ),
     $                               1 )
   60          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   70       CONTINUE
*
         ELSE IF( LSAME( FORM, 'H' ) ) THEN
*
*           A is lower triangular Hermitian
*
            MM = M
            JP = 0
            DO 90 I = 1, ICEIL( NEN, NINT )
               DO 80 J = 1, MIN( N, NEN-JP )
                  MX = MM + J
                  JX = JP + J
                  IF( MX.LE.MEN ) THEN
                     B( MX, JX ) = REAL( BETA ) * REAL( B( MX, JX ) ) +
     $                             REAL( ALPHA ) * REAL( A( MX, JX ) )
                     CALL PBCVECADD( ICONTXT, 'G', MEN-MX, ALPHA,
     $                               A( MX+1, JX ), 1, BETA,
     $                               B( MX+1, JX ), 1 )
                  END IF
   80          CONTINUE
               MM = MM + MINT
               JP = JP + NINT
   90       CONTINUE
*
         ELSE
*
*           A is a rectangular matrix
*
            MM = M + 1
            JP = 1
            DO 100 I = 1, ICEIL( NEN, NINT )
               CALL PBCMATADD( ICONTXT, 'G', MEN-MM+1,
     $                         MIN( N, NEN-JP+1 ), ALPHA, A( MM, JP ),
     $                         LDA, BETA, B( MM, JP ), LDB )
               MM = MM + MINT
               JP = JP + NINT
  100       CONTINUE
         END IF
      END IF
*
      RETURN
*
*     End of PBCTRADD
*
      END
