#ifndef _H_RSTORE_RSTORE
#define _H_RSTORE_RSTORE

#include <rscheme.h>
#include <rscheme/pkgs/lss/lss.h>

struct VMPageRecord; /* forward decl */

typedef struct RStore RStore;

RStore *rstore_open( obj owner, LSS *lss );
obj rstore_root( RStore *store );
void set_rstore_root( RStore *store, obj item );

void rstore_close( RStore *sto );

obj rstore_commit( RStore *store, obj root, obj with_reloc );
void rstore_set_compression( const char *str ); /* currently a global choice */

obj rstore_scan_pob( RStore *store, obj ptr, obj other_failures, 
		     obj with_reloc );

/* set up an indirect page, either a new one or one that's being
   faulted in, by doing:
   (1)  adding each element of [itemv] to the store's pivot table,
         mapping to the appropriate PERS ID
   (2) creating a VMPR to represent the mapping of data at
       the indicated persistent address (page_num)
   (3) installing the VMPR in the store's tables
   (4) adding itemv to the scheme-side <persistent-store>
       to keep it around as long as the pstore's around
       (since the VMPR's mem_address is an (obj *) pointer to the
        contents of itemv)
*/

struct VMPageRecord *register_indirect_page( RStore *store,
					     UINT_32 page_num,
					     obj itemv );

void write_indirect_page_data( RStore *store,
			       int rec_num,
			       int type_id,
			       int instance_id,
			       obj data );

obj unswizzle_symbol_itemv( obj symbol_vec );

obj alloc_area_to_obj( AllocArea *area );
AllocArea *rstore_get_default_area( RStore *store );
AllocArea *rstore_alloc_area( obj item );
AllocArea *make_sub_alloc_area( AllocArea *aa );

void rstore_set_default_area( RStore *store, AllocArea *area );

obj rstore_copy_in( AllocArea *into, obj item );
int alloc_indir_pages( RStore *store, int num_pages );
obj rstore_area_owner( AllocArea *area );

int rstore_count_dirty( RStore *store );


#endif /* _H_RSTORE_RSTORE */
 
