#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/iolib/stdin.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.13
 | File mod date:    1998.12.07 19:36:49
 | System build:     v0.7.3.1-b39, 1999-12-25
 | Owned by module:  iolib
 |
 | Purpose:          input through stdio, <std-input-port>
 `------------------------------------------------------------------------|#

(define-method input-port-char-ready? ((self <std-input-port>))
  (not (eq? (fcanget (file-stream self)) 0)))

;;;

(define-class <input-pipe-port> (<std-input-port>))

(define (open-input-file path)
  (let ((f (fopen (relative-file path) "r")))
    (if f
	(make <std-input-port>
	      name: path
	      input-port-line-number: 1
	      file-stream: f)
	(error "open-input-file: open of `~a' failed" path))))


;;; normally you should not call this directly -- use
;;; `open-input-process' instead, because it may be redirected
;;; to a thread-aware implementation

(define (open-input-process/popen (str <string>))
  (let ((f (popen str "r")))
    (if (not f)
	(error "open-input-process: open of `~a' failed" str))
    (make <input-pipe-port>
	  name: str
	  input-port-line-number: 1
	  file-stream: f)))

(define-method input-port-read-char ((self <std-input-port>))
 (let ((c (peeked-char self)))
   (if c
       (begin
	 (set-peeked-char! self #f)
	 (if (eq? c #\newline)
	     (increment-line self))
	 c)
       (let ((c (fgetc (file-stream self))))
	 (if c
	     (begin
	       (if (eq? c #\newline)
		   (increment-line self))
	       c)
	     $eof-object)))))

(define-syntax (stdin-peek self)
  (or (peeked-char self)
      (let ((c (fgetc (file-stream self))))
	(set-peeked-char! self c)
	c)))

(define-method input-port-peek-char ((self <std-input-port>))
  (or (stdin-peek self) $eof-object))

(define-method collect ((self <std-input-port>) (more? <function>))
  (let loop ((r '())
	     (ch (stdin-peek self)))
    (if (and ch (more? ch))
	(begin
	  (if (eq? ch #\newline)
	      (increment-line self))
	  (loop (cons ch r) 
		(fgetc (file-stream self))))
	(begin
	  (set-peeked-char! self ch)
	  (reverse! r)))))

(define-method input-port-read-line ((self <std-input-port>))
  (let ((line (fgetln (file-stream self))))
    (if line
	(begin
	  (increment-line self)
	  line)
	$eof-object)))
  
(define-method close-input-port ((self <std-input-port>))
  (if (eq? (fclose (file-stream self)) 0)
      (set-file-stream! self 0)
      (error "close-input-port ~s: failed" self)))

(define-method close-input-port ((self <input-pipe-port>))
  (if (eq? (pclose (file-stream self)) 0)
      (set-file-stream! self 0)
      (error "close-input-port ~s: failed" self)))

(define (file->string file)
  (let ((f (fopen (relative-file file) "r")))
    (if f
	(begin
	  (fseek f 0 2)
	  (let* ((size (ftell f))
		 (str (bvec-alloc <string> (+ size 1))))
	    (fseek f 0 0)
	    (fread-fill f str 0 size)
	    (fclose f)
	    str))
	(error "file->string: couldn't open `~a'" file))))
