
;; `tweak-point' operates in window sheet coordinates

(define (tweak-point (in <open-view>) (pt <point>))
  (let ((snp (table-lookup (current-geometry in) pt)))
    ;(dm "tweak-point: ~s ..> ~s" pt snp)
    (if snp
	(begin
	  (set-window-cursor! (content-window in) 
			      (cdr (assq 'snap (mode-cursors in))))
	  snp)
	(begin
	  (set-window-cursor! (content-window in)
			      (cdr (assq (name (current-major-mode in))
					 (mode-cursors in))))
	  pt))))

;;;

(define (my-button-press-handler display
				 #rest ignore
				 #key window
				      event-window
				      x y
				      state)
  (dm 116 "button-press in ~s at (~d ~d)" event-window x y)
  (let ((h (get-property event-window 'button-press #f)))
    (if h
	(apply h event-window (make-point x y) state '())
	(let ((ov (window->open-view event-window)))
	  (if ov
	      ((button-press-proc (current-major-mode ov))
	       ov (make-point x y) state))))))

(define (my-motion-notify-handler display 
				  #rest ignore
				  #key window
				       event-window
				       x
				       y
				       state)
  (let ((h (get-property event-window 'button-motion #f)))
    (if h
	(h window (make-point x y) state)
	(let ((ov (window->open-view event-window)))
	  (if ov
	      (let ((drg (active-drag-proc ov)))
		(if drg
		    (begin
		      (if (vector? drg)
			  (set! drg (vector-ref drg 0)))
		      (drg (tweak-point ov (make-point x y)) state)))))))))

(define (my-button-release-handler display
				   #rest ignore
				   #key window
				        event-window
					x
					y
					state)
  (let ((h (get-property event-window 'button-release #f)))
    (if h
	(h window (make-point x y) state)
	(let ((ov (window->open-view event-window)))
	  (if ov
	      (begin
		(if (vector? (active-drag-proc ov))
		    ((vector-ref (active-drag-proc ov) 1) 
		     (tweak-point ov (make-point x y))
		     state))
		; cancel any currently active drag
		(set-active-drag-proc! ov #f)
		; and reset the cursor
		(reset-cursor! ov)))))))

(define-method status-line-when-sel ((self <graphic-object>))
  (format #f "Graphic ~d" (id self)))

;;;
;;;  make a GC for transient drawing,
;;;  as for drawing new boxes and lines and stuff

(define (transient-gc win)
  (get-property win 'transient-gc (create-transient-gc win)))

(define (create-transient-gc win)
  (let* ((scrn (drawable-screen win))
	 (gc (create-gcontext drawable: win
			      function: 'boole-xor
			      dashes: 3
			      ; this hilight technique is taken from
			      ; X11 (Xlib - vol.1) (O'Reilly) p.205
			      foreground: (bitwise-xor
					   (screen-black-pixel scrn)
					   (screen-white-pixel scrn))
			      line-width: 0
			      line-style: 'on-off-dash
			      background: (screen-white-pixel scrn))))
    (set-property! win 'transient-gc gc)
    gc))

;;;
;;;  construct a temporary procedure for converting (raw) window
;;;  coordinates into user coordinates (with snapping)
;;;

(define (get-window->user-conv-proc (view <open-view>))
  (let* ((fwd-ctm (view-ctm (underlying-object view)))
	 ;; `ctm' converts window-device coords to user coords
	 (ctm (translate (invert-transform fwd-ctm)
			 (view-origin (underlying-object view)))))
    (values (lambda (at)
	      (transform (tweak-point view at) ctm))
	    ctm)))

;;;
;;;  convert one point
;;;

(define (window->user-point (view <open-view>) (at <point>))
  ((get-window->user-conv-proc view) at))
