;;
;;  server daemon
;;

(define *remote-host* #f)

(define (collect-client service)
  (bind ((fd peer (get-next-client service))
	 (peer-host port (inet-socket-hostname peer)))
    (values peer-host fd)))

(define (get-daemon-port) 2059)

(define-hook server-startup)

(define (server-daemon #optional (port default: (get-daemon-port)))
  (let* ((fd (inet-server port))
	 (svc (make-service fd)))
    ;;
    (format #t "server socket fd ~d\n" fd)
    (run-hooks *server-startup-hook*)
    (let loop ()
      (bind ((peer-host fd (collect-client svc))
	     (thread (thread-resume
		      (make-thread (lambda ()
				     (run-server peer-host fd))
				   (format #f "server[~a]" peer-host)))))
	;; single-threaded for now, because I'm
	;; not sure the system can actually handle concurrency
	;; against the object database
	(thread-join thread)
	(loop)))))

(define (run-server peer fd)
  (let* ((i (open-mbox-input-port fd))
	 (o (open-queued-output fd)))
     (app-server peer i o fd)
     (close-input-port i)
     (close-output-port o)
     (fd-close fd)))
