/*
 * SXGROT.C - PGS Grotrian Plot Routines in SX
 *
 * Source Version: 3.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "sx.h"

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_DRAW_GROTRIAN - Scheme level Grotrian plot control routine */

object *SX_draw_grotrian(argl)
   object *argl;
   {PG_device *dev;
    PG_graph *g;

    dev = NULL;
    g   = NULL;
    SS_args(argl,
            G_DEVICE, &dev,
            G_GRAPH, &g,
            0);

    if (dev == NULL)
       SS_error("BAD DEVICE - SX_DRAW_GROTRIAN", argl);

    if (!_SX_grotrian_graphp(g))
       SS_error("GRAPH IS NOT GROTRIAN - SX_DRAW_GROTRIAN", argl);

    PG_grotrian_plot(dev, g);

    return(SS_t);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GROTRIAN_MAPPINGP - return #t iff the object is a grotrian mapping */

object *SX_grotrian_mappingp(obj)
   object *obj;
   {PM_mapping *f;

    if (SX_MAPPINGP(obj))
       {f = SS_GET(PM_mapping, obj);
        return(_SX_grotrian_mappingp(f) ? SS_t : SS_f);}
    else
       return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* SX_GROTRIAN_GRAPHP - return #t iff the object is a grotrian graph */

object *SX_grotrian_graphp(obj)
   object *obj;
   {PG_graph *g;

    if (SX_GRAPHP(obj))
       {g = SS_GET(PG_graph, obj);
        return(_SX_grotrian_graphp(g) ? SS_t : SS_f);}
    else
       return(SS_f);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_GROTRIAN_GRAPHP - return TRUE iff the object is a grotrian graph */

int _SX_grotrian_graphp(g)
   PG_graph *g;
   {return(_SX_grotrian_mappingp(g->f));}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_GROTRIAN_MAPPINGP - return TRUE iff the object is a grotrian mapping */

int _SX_grotrian_mappingp(f)
   PM_mapping *f;
   {return(strcmp(f->category, "Grotrian-Diagram") == 0 ? TRUE : FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _SX_ANY_GROTRIANP - return TRUE if any of the objects in the arg list
 *                   - are grotrian graphs
 */

int _SX_any_grotrianp(argl)
   object *argl;
   {object *obj;
    PM_mapping *f;

    while (SS_consp(argl))
       {obj  = SS_car(argl);
        argl = SS_cdr(argl);
        if (SX_MAPPINGP(obj))
           {f = SS_GET(PM_mapping, obj);
            if (_SX_grotrian_mappingp(f))
               return(TRUE);};};

    return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
