;
; PDBVIEW.SCM - load the SX level part of PDBView
;
; Source Version: 4.0
; Software Release #92-0043
;
; #include <pact-copyright.h>
;

(define pdbview #t)

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------

; AUTOLOAD* - do real autoloading of procedures

(define (autoload* funcname filename)
    "Procedure: loads the specified file when the given procedure is invoked
     and calls the procedure (load on demand).
     Usage: autoload* <procedure> <file>"
    (apply define-global
	   (list (cons funcname 'x)
		 (list load filename #t)
		 (list apply (list eval funcname) 'x))))

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------

; AUTOLOAD - do real autoloading of macros

(define (autoload funcname filename)
    "Macro: loads the specified file when the given macro is invoked
     and calls the macro (load on demand).
     Usage: autoload <macro> <file>"
    (apply define-global-macro
	   (list (cons funcname 'x)
		 (list load filename #t)
		 (list apply (list eval funcname) 'x))))

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------

; SPLICE-OUT - splice the specified item out of the list

(define (splice-out item lst pred)
    "Procedure: Splice the item out of the given list. Identity determined
                by the supplied predicate (eqv? a good choice).
     Usage: splice-out <item> <list> <predicate>"
    (define (helper item old new)
        (if old
	    (let* ((first (car old))
		   (rest (cdr old))
		   (next (list first)))
	      (if (pred item first)
		  (append new rest)
		  (helper item rest (if new
					(append new next)
					next))))
	    new))

    (helper item lst nil))

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------

; FLATTEN-ARGS - flatten an argument list to properly handle things like
;              - (thru n m) than may have been used

(define (flatten-args src dst)
   (if src
       (let* ((frst (list-ref src 0))
	      (rest (list-tail src 1)))
             (if (pair? frst)
		 (flatten-args rest (append (reverse frst) dst))
		 (flatten-args rest (cons frst dst))))
       (reverse dst)))

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------

(define (safe-load file)
  (if (file? file nil nil "global")
      (load file #t)
      (printf nil "Can't find %s\n" file)))

; (define (safe-load file)
;    (load file #t)
;    (printf nil "%s loaded\n" file))

;--------------------------------------------------------------------------
;--------------------------------------------------------------------------

(safe-load "consts.scm")
(safe-load "pdbvio.scm")
(safe-load "pdbvcmd.scm")
(safe-load "synon.scm")
(safe-load "help.scm")
(safe-load "runt.scm")

;(autoload 'do            "runt.scm")
;(autoload 'annot         "annotate.scm")
