/*
 * GSPR_CGM.C - PGS CGM primitive routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
 
#include "pgs.h"

extern SC_dynamic_array
 _PG_CGM_x_point_list,
 _PG_CGM_y_point_list;

/*--------------------------------------------------------------------------*/

/*                         STATE QUERY ROUTINES                             */

/*--------------------------------------------------------------------------*/

/* _PG_CGM_GET_TEXT_EXT_NDC - return the text extent in NDC
 *                          - of the given string
 */

void _PG_CGM_get_text_ext_NDC(dev, s, px, py)
   PG_device *dev;
   char *s;
   REAL *px, *py;
   {REAL tx, ty;

    tx = strlen(s)*(dev->char_width_s + dev->char_space_s) -
         dev->char_space_s;
    ty = dev->char_height_s;

    tx *= 1.6;
    ty *= 2.0;

    *px = tx;
    *py = ty;

    return;}

/*--------------------------------------------------------------------------*/

/*                          STATE CHANGE ROUTINES                           */

/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SET_LOGICAL_OP - set the logical operation */
 
void _PG_CGM_set_logical_op(dev, lop)
   PG_device *dev;
   int lop;
   {dev->logical_op = lop;

/* GOTCHA: Put something appropriate here */
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SET_LINE_STYLE - set the line style */
 
void _PG_CGM_set_line_style(dev, style)
   PG_device *dev;
   int style;
   {dev->line_style = style;

    if (dev->cgm_page_set)
       {if (style > 4)
           style = 1;

        PG_CGM_command(dev, LINE_TYPE, style);};
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SET_LINE_WIDTH - set the line width */
 
void _PG_CGM_set_line_width(dev, width)
   PG_device *dev;
   double width;
   {int lw;
 
    dev->line_width = width;

    if (dev->cgm_page_set)
       {lw = max(1.0, 160.0*width);
        PG_CGM_command(dev, LINE_WIDTH, lw);};
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SET_LINE_COLOR - set the line color */
 
void _PG_CGM_set_line_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {dev->line_color = color;

    if (mapped)
       color = _PG_trans_color(dev, color);

    if (dev->cgm_page_set)
       PG_CGM_command(dev, LINE_COLOUR, color);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SET_TEXT_COLOR - set the color of the text */
 
void _PG_CGM_set_text_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {dev->text_color = color;

    if (mapped)
       color = _PG_trans_color(dev, color);

    if (dev->cgm_page_set)
       PG_CGM_command(dev, TEXT_COLOUR, color);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_SET_FILL_COLOR - sets current fill color */

void _PG_CGM_set_fill_color(dev, color, mapped)
   PG_device *dev;
   int color, mapped;
   {dev->fill_color = color;

    if (dev->cgm_page_set)
       {if (mapped)
           PG_CGM_command(dev, FILL_COLOUR, color+8);
        else
           PG_CGM_command(dev, FILL_COLOUR, color);};

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_SET_FONT - set the character font */

int _PG_CGM_set_font(dev, face, style, size)
   PG_device *dev;
   char *face, *style;
   int size;
   {int nfont, nstyle, ih, dx, dy, nc;
    char *font_name;
    double scale;

    if (!PG_setup_font(dev, face, style, size, &font_name, &nfont, &nstyle))
       return(FALSE);

    scale = 0.77;
    PG_query_screen(dev, &dx, &dy, &nc);
    dev->char_width_s  = scale*size/((dev->window_width/dx)*1200.0);
    dev->char_height_s = scale*size/((dev->window_height/dy)*1200.0);

    ih = PG_CGM_text_mag*dev->char_height_s*dev->window_height;
    if (dev->cgm_page_set)
       {PG_CGM_command(dev, TEXT_FONT_INDEX, nfont+1);
        PG_CGM_command(dev, CHARACTER_HEIGHT, ih);};

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_SET_CHAR_SIZE_NDC - set the character size in NCD */

void _PG_CGM_set_char_size_NDC(dev, x, y)
   PG_device *dev;
   double x, y;
   {int ih;

    dev->char_height_s = (REAL) y;
    dev->char_width_s  = (REAL) x;

    ih = dev->char_height_s*dev->window_height;
    PG_CGM_command(dev, CHARACTER_HEIGHT, ih);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_SET_CHAR_PATH - set the direction along which text will be written
 *                       - defaults to (1, 0)
 */

void _PG_CGM_set_char_path(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_path_x = x;
    dev->char_path_y = y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_SET_CHAR_PRECISION - set the character precision
 *                            - fast and fixed size or
 *                            - slow and flexible
 */

void _PG_CGM_set_char_precision(dev, p)
   PG_device *dev;
   int p;
   {dev->char_precision = p;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_SET_CHAR_SPACE - set the space between characters */

void _PG_CGM_set_char_space(dev, s)
   PG_device *dev;
   double s;
   {dev->char_space = (REAL) s;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_SET_CHAR_UP - set the direction which is up for individual
 *                     - characters
 *                - defaults to (0, 1)
 */

void _PG_CGM_set_char_up(dev, x, y)
   PG_device *dev;
   double x, y;
   {dev->char_up_x = (REAL) x;
    dev->char_up_y = (REAL) y;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SET_CHAR_LINE - set the number characters per line */
 
void _PG_CGM_set_char_line(dev, n)
   PG_device *dev;
   int n;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SET_CLIPPING - set clipping
 *                      - flag = FALSE  -->  clipping off
 *                      - flag = TRUE   -->  clipping on
 */

void _PG_CGM_set_clipping(dev, flag)
   PG_device *dev;
   int flag;
   {int pts[4];
    REAL xmin, xmax, ymin, ymax;

    PG_get_viewport_WC(dev, &xmin, &xmax, &ymin, &ymax);

    if (dev->cgm_page_set)
       {if (flag)
           {_PG_find_clip_region(dev, xmin, xmax, ymin, ymax,
                                 &pts[0], &pts[1],
                                 &pts[2], &pts[3], flag, TRUE);

            PG_CGM_command(dev, CLIP_RECTANGLE, pts);};

        PG_CGM_command(dev, CLIP_INDICATOR, flag);};
 
    dev->clipping = flag;

    return;}
 
/*--------------------------------------------------------------------------*/

/*                          MOVE AND DRAW ROUTINES                          */

/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_MOVE_GR_ABS - move the current graphics cursor position to the
 *                     - given absolute coordinates in WC
 */
 
void _PG_CGM_move_gr_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->gcurx = x;
    dev->gcury = y;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_MOVE_TX_ABS - move the current text cursor position to the
 *                     - given coordinates in WC
 */
 
void _PG_CGM_move_tx_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {
 
/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx = x;
    dev->tcury = y;

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_MOVE_TX_REL - move the current text cursor position to the
 *                     - given relative coordinates in WC
 */
 
void _PG_CGM_move_tx_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {

/* if log axis options have been used take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    dev->tcurx += x;
    dev->tcury += y;
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_DRAW_TO_ABS - draw a line from current position to
 *                     - absolute position (x, y)
 *                     - in WC
 */
 
void _PG_CGM_draw_to_abs(dev, x, y)
   PG_device *dev;
   double x, y;
   {int pts[4], flag, xlf, ylf;
    REAL x1, y1, x2, y2, xmn, xmx, ymn, ymx, tmp;

    if (dev->clipping)
       {PG_get_bound(dev, &xmn, &xmx, &ymn, &ymx);
        if (xmx < xmn)
           {tmp = xmx;
	    xmx = xmn;
    	    xmn = tmp;}

        if (ymx < ymn)
           {tmp = ymx;
	    ymx = ymn;
	    ymn = tmp;}

        x1   = dev->gcurx;
        y1   = dev->gcury;
        x2   = x;
        y2   = y;
        xlf  = dev->ifxlog;
        ylf  = dev->ifylog;
        flag = 0;

        PG_clip_line(&flag, &x1, &y1, &x2, &y2, 
                     xmn, xmx, ymn, ymx, xlf, ylf);
        if (flag == 0)
           return;
        else
           {x = x2;
            y = y2;};}
        
/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);

    if (dev->cgm_page_set)
       {if (!dev->clipping)
           {x1 = dev->gcurx;
            y1 = dev->gcury;}

        dev->gcurx = x;
        dev->gcury = y;

        WtoS(dev, x1, y1);
        WtoS(dev, x, y);
        StoP(dev, x1, y1, pts[0], pts[1]);
        StoP(dev, x, y, pts[2], pts[3]);
 
        PG_CGM_command(dev, POLYLINE(4), pts);};
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_DRAW_TO_REL - draw a line from current position to
 *                     - relative position (x, y)
 *                     - in WC
 */
 
void _PG_CGM_draw_to_rel(dev, x, y)
   PG_device *dev;
   double x, y;
   {REAL x1, y1, x2, y2;
    int pts[4];
 
/* if log axis options are on, take logs */
    if (dev->ifxlog)
       x = log10(ABS(x) + SMALL);
    if (dev->ifylog)
       y = log10(ABS(y) + SMALL);
 
    if (dev->cgm_page_set)
       {x1 = dev->gcurx;
        y1 = dev->gcury;
        x2 = dev->gcurx + x;
        y2 = dev->gcury + y;

        dev->gcurx = x2;
        dev->gcury = y2;

        WtoS(dev, x1, y1);
        WtoS(dev, x2, y2);
        StoP(dev, x1, y1, pts[0], pts[1]);
        StoP(dev, x2, y2, pts[2], pts[3]);
 
        PG_CGM_command(dev, POLYLINE(4), pts);};
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_DRAW_CURVE - draw a PG_curve */
 
void _PG_CGM_draw_curve(dev, crv, clip)
   PG_device *dev;
   PG_curve *crv;
   int clip;
   {int i, flag, n, xo, yo, ix, ixo, iy, iyo, *pts;
    int ix1, iy1;
    int cxx, cxn, cyx, cyn;
    int *x, *y;
    REAL xmin, xmax, ymin, ymax;

    if (dev->cgm_page_set)
       {flag = TRUE;
	
	PG_get_viewport_WC(dev, &xmin, &xmax, &ymin, &ymax);
	_PG_find_clip_region(dev, xmin, xmax, ymin, ymax,
			     &cxn, &cyn, &cxx, &cyx, dev->clipping, TRUE);

	n  = crv->n;
	x  = crv->x;
	y  = crv->y;
        xo = crv->x_origin;
        yo = crv->y_origin;

	pts = FMAKE_N(int, 2*n, "_PG_CGM_DRAW_CURVE:pts");
    
	if (cyn > cyx)
	   {i   = cyn;
	    cyn = cyx;
	    cyx = i;};
    
	for (i = 0, ix = 0, iy = 1; i < n; i++)
	    {ixo = ix1;
	     iyo = iy1;
	     ix1 = x[i] + xo;
	     iy1 = y[i] + yo;
       
	     if (i == 0)
	        continue;

	     if ((ix1 == ixo) && (iy1 == iyo))
	        continue;

	     if (clip && dev->clipping)
	        {if (((ix1 < cxn) && (ixo < cxn)) ||
		     ((ix1 > cxx) && (ixo > cxx)))
		    {flag = TRUE;
		     continue;}

		 if (((iy1 < cyn) && (iyo < cyn)) ||
		     ((iy1 > cyx) && (iyo > cyx)))
		    {flag = TRUE;
		     continue;};};
/*
	     if (flag)
	        {dev->gcurx = ixo;
		 dev->gcury = iyo;
		 flag = FALSE;}

	     if (ix == 0)
*/
	     if (flag)
	        {pts[ix] = ixo;
		 pts[iy] = iyo;

		 ix +=2;
		 iy +=2;
	         flag = FALSE;}

	     pts[ix] = ix1;
	     pts[iy] = iy1;

	     ix += 2;
	     iy += 2;};
        
        PG_CGM_command(dev, POLYLINE(ix), pts);

        SFREE(pts);};

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_DRAW_DISJOINT_POLYLINE_2 - draws disjoint two dimensional
 *                                  - line segments specified in WC
 */

void _PG_CGM_draw_disjoint_polyline_2(dev, x, y, n, flag, coord)
   PG_device *dev;
   REAL *x, *y;
   long n;
   int flag, coord;
   {int i, ix, iy, *pts;
    int ix1, ix2, iy1, iy2;
    int cxx, cxn, cyx, cyn;
    REAL *px, *py;
    REAL rx1, ry1, rx2, ry2;
    REAL xmin, xmax, ymin, ymax;

/* if auto ranging or domaining is on the data will control the WC system */
    if (flag && (dev->autorange || dev->autodomain))
       PG_set_limits(dev, x, y, 2*n, CARTESIAN);

    px = x;
    py = y;

    PG_move_gr_abs(dev, x[0], y[0]);

    PG_get_viewport_WC(dev, &xmin, &xmax, &ymin, &ymax);
    _PG_find_clip_region(dev, xmin, xmax, ymin, ymax,
                         &cxn, &cyx, &cxx, &cyn, dev->clipping, TRUE);

    pts = FMAKE_N(int, 4*n, "_PG_CGM_DRAW_DISJOINT_POLYLINE_2:pts");
    for (i = 0, ix = 0, iy = 1; i < n; i++)
        {rx1 = *px++;
         ry1 = *py++;
         rx2 = *px++;
         ry2 = *py++;
         
         if (coord)
            {if (dev->ifxlog)
                {rx1 = log10(ABS(rx1) + SMALL);
                 rx2 = log10(ABS(rx2) + SMALL);};
             if (dev->ifylog)
                {ry1 = log10(ABS(ry1) + SMALL);
                 ry2 = log10(ABS(ry2) + SMALL);};
 
             WtoS(dev, rx1, ry1);
             StoP(dev, rx1, ry1, ix1, iy1);
             WtoS(dev, rx2, ry2);
             StoP(dev, rx2, ry2, ix2, iy2);}
         else
            {StoP(dev, rx1, ry1, ix1, iy1);
             StoP(dev, rx2, ry2, ix2, iy2);};

         if ((ix1 == ix2) && (iy1 == iy2))
	    continue;

/* do simple clipping */
	 if (dev->clipping &&
	     (((ix1 < cxn) && (ix2 < cxn)) ||
	      ((ix1 > cxx) && (ix2 > cxx)) ||
	      ((iy1 < cyn) && (iy2 < cyn)) ||
	      ((iy1 > cyx) && (iy2 > cyx))))
	    continue;

	 pts[ix]   = ix1;
	 pts[iy]   = iy1;
	 pts[ix+2] = ix2;
	 pts[iy+2] = iy2;

         ix += 4;
         iy += 4;};

    PG_CGM_command(dev, DISJOINT_POLYLINE(ix), pts);

    SFREE(pts);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_SHADE_POLY - polygon shading routine */

void _PG_CGM_shade_poly(dev, x, y, n)
   PG_device *dev;
   REAL *x, *y;
   int n;
   {int i, ix, iy, *pts, tn;
    REAL x1, y1, *tx, *ty;

    if (dev->cgm_page_set)
       {if (dev->clipping)
           {tn = 3.0*n;

	    SC_SIZE_DYNAMIC_F(REAL, _PG_CGM_x_point_list, tn,
			      "_PG_CGM_SHADE_POLY:x");
	    SC_SIZE_DYNAMIC_F(REAL, _PG_CGM_y_point_list, tn,
			      "_PG_CGM_SHADE_POLY:y");

	    tx = SC_ARRAY_DYNAMIC(REAL, _PG_CGM_x_point_list);
	    ty = SC_ARRAY_DYNAMIC(REAL, _PG_CGM_y_point_list);

	    SC_N_DYNAMIC(_PG_CGM_x_point_list) = 0;
	    SC_N_DYNAMIC(_PG_CGM_y_point_list) = 0;

            PG_clip_polygon(dev, tx, ty, &tn, x, y, n);

            x = tx;
            y = ty;
            n = tn;};
       
        if (n > 0)     
           {pts = FMAKE_N(int, 2*n, "_PG_CGM_SHADE_POLY:pts");
            for (i = 0, ix = 0, iy = 1; i < n; i++, ix += 2, iy += 2)
                {x1 = x[i];
                 y1 = y[i];
                 WtoS(dev, x1, y1);
                 StoP(dev, x1, y1, pts[ix], pts[iy]);};
 
            PG_CGM_command(dev, POLYGON(2*n), pts);

            SFREE(pts);};};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_CGM_FILL_CURVE - fill a closed PG_curve */

void _PG_CGM_fill_curve(dev, crv)
   PG_device *dev;
   PG_curve *crv;
   {int i, n, ix, iy, xo, yo, *pts;
    int *x, *y;

    n  = crv->n;
    x  = crv->x;
    y  = crv->y;
    xo = crv->x_origin;
    yo = crv->y_origin;
    
    if (dev->cgm_page_set)
       {pts = FMAKE_N(int, 2*n, "_PG_CGM_FILL_CURVE:pts");
        for (i = 0, ix = 0, iy = 1; i < n; i++, ix += 2, iy += 2)
            {pts[ix] = x[i] + xo;
             pts[iy] = y[i] + yo;};
 
        PG_CGM_command(dev, POLYGON(2*n), pts);

        PG_CGM_command(dev, LINE_COLOUR, dev->fill_color);
        PG_CGM_command(dev, POLYLINE(2*n), pts);
        PG_CGM_command(dev, LINE_COLOUR, dev->line_color);

        SFREE(pts);};

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_CGM_PUT_IMAGE - put the image on the screen
 *                   - the image buffer may be overwritten by the pseudo
 *                   - color mapping if it is needed!!
 */

void _PG_CGM_put_image(dev, bf, ix, iy, nx, ny)
   PG_device *dev;
   unsigned char *bf;
   int ix, iy, nx, ny;
   {int params[10], dx, dy, n, i, k, l;
    REAL rv;
    int n_pal_colors, n_dev_colors;
    unsigned char *pbf;
    PG_palette *pal;
    RGB_color_map *pseudo_cm;

    pal          = dev->current_palette;
    n_dev_colors = dev->absolute_n_color;
    n_pal_colors = pal->n_pal_colors;
    pseudo_cm    = pal->pseudo_colormap;

    PG_invert_image_data(bf, nx, ny, 1);

/* shift the pixels by the bottom eight mandatory colors
 * this gets into the expected palette range
 */
    if (dev->current_palette != dev->palettes)
       {n   = nx*ny;
	pbf = bf;
	for (i = 0; i < n; i++)
	    *pbf++ += 8;};

    if ((n_dev_colors < n_pal_colors) && (pseudo_cm != NULL))
       {unsigned char *pbf;

        pbf = bf;
        PM_random(-1);
        for (l = 0; l < ny; l++)
            for (k = 0; k < nx; k++)
                {i      = *pbf;
                 rv     = 3.5*PM_random(1) - 0.83;
                 *pbf++ = (rv < pseudo_cm[i].red) ?
                          pseudo_cm[i].green : pseudo_cm[i].blue;};};

    n  = nx*ny;
    dx = nx*dev->resolution_scale_factor;
    dy = ny*dev->resolution_scale_factor;

/*
    params[0] = ix;
    params[1] = iy;
    params[2] = ix + dx;
    params[3] = iy - dy;
    params[4] = ix + dx;
    params[5] = iy;
*/
    params[0] = ix;
    params[1] = iy + dy;
    params[2] = ix + dx;
    params[3] = iy;
    params[4] = ix + dx;
    params[5] = iy + dy;

    params[6] = nx;
    params[7] = ny;
    params[8] = 0;
    params[9] = 1;
    PG_CGM_command(dev, CELL_ARRAY(params, n), bf);

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

