/*
 * GSDV_BGI.C - PGS BGI routines
 *
 * Source Version: 2.0
 * Software Release #92-0043
 *
 */

#include "cpyright.h"
  
#include "pgs.h"

#define MORE_WINDOW

/* PG_PLACE_TEXT - unlike PG_WRITE_ABS this doesn't effect the text buffer */

#define PG_PLACE_TEXT(dev, dx, dy, p)                                        \
   {dx = dev->tcurx;                                                         \
    dy = dev->tcury;                                                         \
    PG_move_tx_abs(dev, dx, dy);                                             \
    PG_get_text_ext(dev, p, &dx, &dy);                                       \
    dev->tcurx += dx;                                                        \
    PG_OUT_TEXT(p);}

static int
 n_screen_opens = 0;

static int
 SC_DECLARE(_PG_bgi_setup_font, (PG_device *dev, char *bf)),
 SC_DECLARE(_PG_bgi_open_console,
	    (char *title, char *type, int bckgr, double xf,
	     double yf, double dxf, double dyf));

static char
 SC_DECLARE(*_PG_backup_char, (PG_device *dev, char *p, int n)),
 SC_DECLARE(*_PG_bgi_fgets, 
            (char *buffer, int maxlen, FILE *stream));

static PG_device
 SC_DECLARE(*_PG_bgi_open_screen,
	    (PG_device *dev, double xf, double yf, double dxf, double dyf));

static void
 SC_DECLARE(_PG_bgi_query_pointer,
	    (PG_device *dev, int *px, int *py, int *pb)),
 SC_DECLARE(_PG_bgi_clear_page, (PG_device *dev, int i)),
 SC_DECLARE(_PG_bgi_clear_window, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_clear_viewport, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_clear_region_NDC,
	    (PG_device *dev, double xmn, double xmx,
	     double ymn, double ymx, int pad)),
 SC_DECLARE(_PG_bgi_close_console, (byte)),
 SC_DECLARE(_PG_bgi_close_device, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_expose_device, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_finish_plot, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_make_device_current, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_map_to_color_table, 
            (PG_device *dev, PG_palette *pal)),
 SC_DECLARE(_PG_bgi_next_line, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_puts, (char *bf)),
 SC_DECLARE(_PG_bgi_query_screen, 
            (PG_device *dev, int *pdx, int *pdy, int *pnc)),
 SC_DECLARE(_PG_bgi_release_current_device, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_update_vs, (PG_device *dev)),
 SC_DECLARE(_PG_bgi_write_text, (PG_device *dev, FILE *fp, char *s));

/* from corresponding PR file */

int
 SC_DECLARE(_PG_bgi_set_font,
	    (PG_device *dev, char *face, char *style, int size));

void
 SC_DECLARE(_PG_bgi_draw_disjoint_polyline_2,
	    (PG_device *dev, REAL *x, REAL *y,
	     long n, int flag, int coord)),
 SC_DECLARE(_PG_bgi_draw_curve, 
            (PG_device *dev, PG_curve *crv, int clip)),
 SC_DECLARE(_PG_bgi_draw_to_abs, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_draw_to_rel, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_get_text_ext_NDC,
	    (PG_device *dev, char *s, REAL *px, REAL *py)),
 SC_DECLARE(_PG_bgi_set_clipping, (PG_device *dev, int flag)),
 SC_DECLARE(_PG_bgi_set_char_line, (PG_device *dev, int n)),
 SC_DECLARE(_PG_bgi_set_char_path, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_set_char_precision, (PG_device *dev, int p)),
 SC_DECLARE(_PG_bgi_set_char_space, (PG_device *dev, double s)),
 SC_DECLARE(_PG_bgi_set_char_size_NDC, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_set_char_up, 
            (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_set_fill_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_bgi_set_line_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_bgi_set_line_style, (PG_device *dev, int style)),
 SC_DECLARE(_PG_bgi_set_line_width, (PG_device *dev, double width)),
 SC_DECLARE(_PG_bgi_set_logical_op, (PG_device *dev, int lop)),
 SC_DECLARE(_PG_bgi_set_text_color, 
            (PG_device *dev, int color, int mapped)),
 SC_DECLARE(_PG_bgi_shade_poly, 
            (PG_device *dev, REAL *x, REAL *y, int n)),
 SC_DECLARE(_PG_bgi_fill_curve, (PG_device *dev, PG_curve *crv)),
 SC_DECLARE(_PG_bgi_move_gr_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_move_tx_abs, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_move_tx_rel, (PG_device *dev, double x, double y)),
 SC_DECLARE(_PG_bgi_get_image,
	    (PG_device *dev, unsigned char *bf, int ix, int iy,
	     int nx, int ny)),
 SC_DECLARE(_PG_bgi_put_image,
	    (PG_device *dev, unsigned char *bf, int ix, int iy,
	     int nx, int ny));

PFInt
 PG_open_console_hook = _PG_bgi_open_console;

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* PG_SETUP_WINDOW_DEVICE - do the device dependent device initialization
 *                        - for PG_make_device
 */

void PG_setup_window_device(d, isvis)
   PG_device *d;
   int isvis;
   {if (SC_strstri(d->name, "TEXT") != NULL)
       d->type_index = TEXT_WINDOW_DEVICE;
    else
       d->type_index = GRAPHIC_WINDOW_DEVICE;

    d->is_visible = isvis;

    d->query_pointer          = _PG_bgi_query_pointer;
    d->clear_page             = _PG_bgi_clear_page;
    d->clear_window           = _PG_bgi_clear_window;
    d->clear_viewport         = _PG_bgi_clear_viewport;
    d->clear_region_NDC       = _PG_bgi_clear_region_NDC;
    d->close_console          = _PG_bgi_close_console;
    d->close_device           = _PG_bgi_close_device;
    d->draw_dj_polyln_2       = _PG_bgi_draw_disjoint_polyline_2;
    d->draw_curve             = _PG_bgi_draw_curve;
    d->draw_to_abs            = _PG_bgi_draw_to_abs;
    d->draw_to_rel            = _PG_bgi_draw_to_rel;
    d->expose_device          = _PG_bgi_expose_device;
    d->finish_plot            = _PG_bgi_finish_plot;
    d->get_char               = getch;
    d->get_image              = _PG_bgi_get_image;
    d->get_text_ext_NDC       = _PG_bgi_get_text_ext_NDC;
    d->ggets                  = (PFfgets) _PG_bgi_fgets;
    d->gputs                  = NULL;
    d->make_device_current    = _PG_bgi_make_device_current;
    d->map_to_color_table     = _PG_bgi_map_to_color_table;
    d->match_rgb_colors       = _PG_match_rgb_colors;
    d->move_gr_abs            = _PG_bgi_move_gr_abs;
    d->move_tx_abs            = _PG_bgi_move_tx_abs;
    d->move_tx_rel            = _PG_bgi_move_tx_rel;
    d->next_line              = _PG_bgi_next_line;
    d->open_screen            = _PG_bgi_open_screen;
    d->put_image              = _PG_bgi_put_image;
    d->query_screen           = _PG_bgi_query_screen;
    d->release_current_device = _PG_bgi_release_current_device;
    d->set_bound              = _PG_set_bound;
    d->set_clipping           = _PG_bgi_set_clipping;
    d->set_char_line          = _PG_bgi_set_char_line;
    d->set_char_path          = _PG_bgi_set_char_path;
    d->set_char_precision     = _PG_bgi_set_char_precision;
    d->set_char_size_NDC      = _PG_bgi_set_char_size_NDC;
    d->set_char_space         = _PG_bgi_set_char_space;
    d->set_char_up            = _PG_bgi_set_char_up;
    d->set_fill_color         = _PG_bgi_set_fill_color;
    d->set_font               = _PG_bgi_set_font;
    d->set_line_color         = _PG_bgi_set_line_color;
    d->set_line_style         = _PG_bgi_set_line_style;
    d->set_line_width         = _PG_bgi_set_line_width;
    d->set_logical_op         = _PG_bgi_set_logical_op;
    d->set_text_color         = _PG_bgi_set_text_color;
    d->shade_poly             = _PG_bgi_shade_poly;
    d->fill_curve             = _PG_bgi_fill_curve;
    d->update_vs              = _PG_bgi_update_vs;
    d->write_text             = _PG_bgi_write_text;
    
    d->expose_event_handler.fnc     = NULL;
    d->update_event_handler.fnc     = NULL;
    d->mouse_down_event_handler.fnc = NULL;
    d->mouse_up_event_handler.fnc   = NULL;
    d->key_down_event_handler.fnc   = NULL;
    d->key_up_event_handler.fnc     = NULL;
    d->default_event_handler.fnc    = NULL;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_OPEN_SCREEN - initialize a "window" on a display screen */
 
static PG_device *_PG_bgi_open_screen(dev, xf, yf, dxf, dyf)
   PG_device *dev;
   double xf, yf, dxf, dyf;
   {REAL _txw0, _txh0;
    int n_fonts, n_colors, dev_width, dev_height;
    char *name;
    REAL view_x_max, view_y_max, intensity;
    short smode;
    char Lightest, Light, Light_Gray, Dark_Gray, Dark, Darkest;
    VGA_color *colormap;
    PG_font_family *ff;

    PG_setup_markers();

    name = dev->name;
    n_colors = 0;

    if (SC_strstri(name, "TEXT") != NULL)
       dev->type_index = TEXT_WINDOW_DEVICE;
    else
       dev->type_index = GRAPHIC_WINDOW_DEVICE;

    if (n_screen_opens++ == 0)
       {int gdriver = DETECT, gmode;

        initgraph(&gdriver, &gmode, "");
        PG_reset_mouse();
        PG_set_mouse_position(1, 1);
        PG_show_mouse();};
 
    dev->quadrant = QUAD_FOUR;

/* get the window shape in NDC */
    if ((xf == 0.0) && (yf == 0.0))
       {xf = 0.5;
        yf = 0.1;};

    if ((dxf == 0.0) && (dyf == 0.0))
       {dxf = 0.5;
        dyf = 0.5;};

    PG_query_screen(dev, &dev_width, &dev_height, &n_colors);

/* GOTCHA: The following pixel coordinate limits may be incorrect */
/* set device pixel coordinate limits */
    dev->min_pc_x = INT_MIN + dev_width;
    dev->max_pc_x = INT_MAX - dev_width;
    dev->min_pc_y = INT_MIN + dev_height;
    dev->max_pc_y = INT_MAX - dev_height;
 
    dev->physical_pixel_width  = dev_width;
    dev->physical_pixel_height = dev_height;
    dev->physical_char_line    = 80;
    dev->physical_lines_page   = 25;

/* change the devices idea of window shape from NDC to pixels */
    dev->window_x      = xf*dev->physical_pixel_width;
    dev->window_y      = yf*dev->physical_pixel_height;
    dev->window_width  = dxf*dev->physical_pixel_width;
    dev->window_height = dyf*dev->physical_pixel_width;

    dev->window_x_off  = dev->window_x;
    dev->window_y_off  = dev->window_y;

/* get other window attributes */
    dev->ncolor = n_colors;
    dev->absolute_n_color = n_colors;

/* decide on the overall color layout and choose WHITE or BLACK background */
    intensity = dev->max_intensity*MAXPIX;
    if (dev->background_color_white)
       {if (n_colors == 2)
           {Color_Map(dev, 15, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7);
            dev->ncolor = N_COLORS;
            Lightest   = 0;
            Light      = 0;
            Light_Gray = 0;
            Dark_Gray  = 0;
            Dark       = 0;
            Darkest    = intensity;}
        else
           {Color_Map(dev, 15, 1, 2, 3, 4, 5, 6, 7,
                      8, 9, 10, 11, 12, 14, 13, 15);
            dev->ncolor = N_COLORS;
            Lightest   = 0;
            Light      = intensity;
            Light_Gray = 0.8*intensity;
            Dark_Gray  = 0.5*intensity;
            Dark       = 0;
            Darkest    = intensity;};}
    else
       {if (n_colors == 2)
           {Color_Map(dev, 15, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7);
            dev->ncolor = N_COLORS;
            Lightest   = intensity;
            Light      = intensity;
            Light_Gray = intensity;
            Dark_Gray  = intensity;
            Dark       = intensity;
            Darkest    = 0;}
        else
           {Color_Map(dev, 15, 1, 2, 3, 4, 5, 6, 7,
                      8, 9, 10, 11, 12, 14, 13, 15);
            dev->ncolor = N_COLORS;
            Lightest   = intensity;
            Light      = intensity;
            Light_Gray = 0.8*intensity;
            Dark_Gray  = 0.5*intensity;
            Dark       = 0;
            Darkest    = 0;};};

    colormap = FMAKE_N(VGA_color, N_COLORS,
                       "_PG_BGI_OPEN_SCREEN:colormap");

    colormap[1].red    = Dark;
    colormap[1].green  = Dark;
    colormap[1].blue   = Light;
    
    colormap[2].red    = Dark;
    colormap[2].green  = Light;
    colormap[2].blue   = Dark;
    
    colormap[3].red    = Dark;
    colormap[3].green  = Light;
    colormap[3].blue   = Light;
    
    colormap[4].red    = Light;
    colormap[4].green  = Dark;
    colormap[4].blue   = Dark;

    colormap[5].red    = Light;
    colormap[5].green  = Dark;
    colormap[5].blue   = Light;
    
    colormap[6].red    = Light_Gray;
    colormap[6].green  = Dark_Gray;
    colormap[6].blue   = Dark;
    
    colormap[7].red    = Lightest;
    colormap[7].green  = Lightest;
    colormap[7].blue   = Lightest;

    colormap[8].red    = Dark_Gray;
    colormap[8].green  = Dark_Gray;
    colormap[8].blue   = Dark_Gray;
    
    colormap[9].red    = Dark;
    colormap[9].green  = Dark;
    colormap[9].blue   = Light_Gray;
    
    colormap[10].red   = Dark;
    colormap[10].green = Light_Gray;
    colormap[10].blue  = Dark;
    
    colormap[11].red   = Dark;
    colormap[11].green = Light_Gray;
    colormap[11].blue  = Light_Gray;
    
    colormap[12].red   = Light_Gray;
    colormap[12].green = Dark;
    colormap[12].blue  = Dark;
    
    colormap[13].red   = Light_Gray;
    colormap[13].green = Dark;
    colormap[13].blue  = Dark_Gray;

    colormap[14].red   = Light_Gray;
    colormap[14].green = Light_Gray;
    colormap[14].blue  = Dark;

    colormap[15].red   = Darkest;
    colormap[15].green = Darkest;
    colormap[15].blue  = Darkest;
    
/*    setbkcolor(LIGHTGRAY); */

    dev->colormap = colormap;

    PG_set_color_text(dev, dev->WHITE, TRUE);
    PG_set_color_line(dev, dev->WHITE, TRUE);

/* compute the view port */
    if (dev->view_x == 0.0)
       {dev->view_x = 0.225;
        dev->view_y = 0.165;};

    if (dev->view_width == 0.0)
       dev->view_width = 0.55;

    if (dev->view_height == 0.0)
       dev->view_height = 1.33333333333*dev->view_width*dev->view_aspect;

    view_x_max = dev->view_x + dev->view_width;
    view_y_max = dev->view_y + dev->view_height;

/* draw a box around the window */
    PG_clear_window(dev);

/* set the view port */
    PG_set_viewport(dev, dev->view_x, view_x_max, dev->view_y, view_y_max);
    PG_set_window(dev, 0.0, 1.0, 0.0, 1.0);
 
/* initialize text size info */
    dev->txt_ratio = 0.9;
    _txw0          = 1.0/80.0;
    _txh0          = dev->txt_ratio/50.0;
    PG_set_char_size_NDC(dev, _txw0, _txh0);
 
/* load default font */

    ff = PG_make_font_family(dev, "helvetica", NULL, 4,
                             "helv",
                             "helv",
                             "helv",
                             "helv");

    ff = PG_make_font_family(dev, "times", ff, 4,
                             "tms rmn",
                             "tms rmn",
                             "tms rmn",
                             "tms rmn");

    ff = PG_make_font_family(dev, "courier", ff, 4,
                             "courier",
                             "courier",
                             "courier",
                             "courier");

    dev->font_family = ff;

    PG_set_font(dev, "helvetica", "medium", 12);
        
    return(dev);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_QUERY_SCREEN - query some physical device characteristics */

static void _PG_bgi_query_screen(dev, pdx, pdy, pnc)
   PG_device *dev;
   int *pdx, *pdy, *pnc;
   {*pdx = getmaxx() + 1;
    *pdy = getmaxy() + 1;
    *pnc = getmaxcolor() + 1;

    return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_MAP_TO_COLOR_TABLE - map the PGS palette to host
 *                            - color table values
 */

static void _PG_bgi_map_to_color_table(dev, pal)
   PG_device *dev;
   PG_palette *pal;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_OPEN_CONSOLE - open up a special window to be used as a console or
 *                      - terminal window for systems which can't do this for
 *                      - themselves (i.e. MacIntosh) or the SINGLE SCREEN
 *                      - devices
 */
 
static int _PG_bgi_open_console(title, type, bckgr, xf, yf, dxf, dyf)
   char *title, *type;
   int bckgr;
   double xf, yf, dxf, dyf;
   {char s[MAXLINE], **cons_bf;
    REAL dx, dy, line_frac;
    int i, n_lines, n_chars;
    PG_device *dev;

    PG_setup_markers();

    sprintf(s, "%s-TEXT", getenv("DISPLAY"));
    dev = PG_make_device(s, type, title);
    dev->background_color_white = bckgr;
    PG_open_screen(dev, xf, yf, dxf, dyf);

    PG_set_viewport(dev, 0.01, 0.98, 0.01, 0.98);
    PG_set_window(dev, 0.0, 1.0, 0.0, 1.0);

    PG_open_text_box(dev, title, xf, yf, dxf, dyf);

    dev->type_index = TEXT_WINDOW_DEVICE;
    PG_set_clipping(dev, TRUE);

    PG_console_device = dev;

    putln = (PFfprintf) PG_fprintf;
    getln = (PFfgets) dev->ggets;

    return(TRUE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_CLOSE_DEVICE - close a device */
 
static void _PG_bgi_close_device(dev)
   PG_device *dev;
   {n_screen_opens--;
    if (n_screen_opens == 0)
       closegraph();

/* clean up the device */
   _PG_rl_device(dev);

   return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_CLOSE_CONSOLE - close the console device */
 
static void _PG_bgi_close_console()
   {PG_close_device(PG_console_device);

/* clean up the device */
    _PG_rl_device(PG_console_device);

    PG_console_device = NULL;

/* connect I/O to standard functions */
    putln = io_printf_hook;
    getln = io_gets_hook;
    
    return;}

/*--------------------------------------------------------------------------*/

/*                           SCREEN STATE ROUTINES                          */

/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_CLEAR_WINDOW - clear the screen */
 
static void _PG_bgi_clear_window(dev)
   PG_device *dev;
   {int x0, y0, x1, y1;
    int pts[8];

    PG_make_device_current(dev);

    x0 = dev->window_x;
    y0 = dev->window_y;
    x1 = dev->window_x + dev->window_width;
    y1 = dev->window_y + dev->window_height;
    setfillstyle(SOLID_FILL, dev->BLACK);

    pts[0] = x0;
    pts[1] = y0;
    pts[2] = x1;
    pts[3] = y0;
    pts[4] = x1;
    pts[5] = y1;
    pts[6] = x0;
    pts[7] = y1;
    fillpoly(4, pts);
 
    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_CLEAR_VIEWPORT - clear the viewport */
 
static void _PG_bgi_clear_viewport(dev)
   PG_device *dev;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_CLEAR_REGION_NDC - clear the rectangular region specified in NDC */
 
static void _PG_bgi_clear_region_NDC(dev, xmn, xmx, ymn, ymx, pad)
   PG_device *dev;
   double xmn, xmx, ymn, ymx;
   int pad;
   {int ix, iy, iw, ih;

    PG_make_device_current(dev);

    StoP(dev, xmn, ymx, ix, iy);
    StoP(dev, xmx, ymn, iw, ih);

    ix -= pad;
    iy -= pad;
    iw -= (ix - 2*pad);
    ih -= (iy - 2*pad);
/*    XClearArea(dev->display, dev->window, ix, iy,
      (unsigned int) iw, (unsigned int) ih, TRUE); */
    
    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_UPDATE_VS - update the view surface for the given device */
 
static void _PG_bgi_update_vs(dev)
   PG_device *dev;
   {return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_FINISH_PLOT - do what's necessary to finish up a graphical image
 *                     - and get the device updated with the image
 *                     - after this function nothing more can be added to
 *                     - the image
 */
 
static void _PG_bgi_finish_plot(dev)
   PG_device *dev;
   {PG_make_device_current(dev);

    PG_update_vs(dev);

    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_CLEAR_PAGE - clear the current page
 *                    - and go to the line i on the screen
 */
 
static void _PG_bgi_clear_page(dev, i)
   PG_device *dev;
   int i;
   {REAL dy;
    char **bf;
    int line_no;

    PG_make_device_current(dev);

    PG_clear_window(dev);
    if (dev->type_index == TEXT_WINDOW_DEVICE)
       {dy = dev->char_height_s/dev->byw_s;
        PG_move_tx_abs(dev, 0.0, 1.0 - dy);

        bf      = dev->text_buffer;
        line_no = dev->line_no;
        for (i = 0; i < line_no; i++)
            {SFREE(bf[i]);};

        dev->line_no = 0;};
 
    PG_release_current_device(dev);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_EXPOSE_DEVICE - make this device the topmost one */
 
static void _PG_bgi_expose_device(dev)
   PG_device *dev;
   {return;}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_MAKE_DEVICE_CURRENT - make this device the current one for drawing
 *                             - purposes
 */
 
static void _PG_bgi_make_device_current(dev)
   PG_device *dev;
   {PG_set_clipping(dev, dev->clipping);
    PG_move_tx_abs(dev, dev->tcurx, dev->tcury);
    PG_set_font(dev, dev->type_face, dev->type_style, dev->type_size);
    PG_set_color_text(dev, dev->text_color, TRUE);

    return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_RELEASE_CURRENT_DEVICE - make no device current
 *                                - (SUN in its brilliance needs this)
 */
 
static void _PG_bgi_release_current_device(dev)
   PG_device *dev;
   {return;}
        
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_WRITE_TEXT - write out text to the appropriate device */
 
static void _PG_bgi_write_text(dev, fp, s)
   PG_device *dev;
   FILE *fp;
   char *s;
   {REAL x, y;

    PG_get_text_ext(dev, s, &x, &y);
    dev->tcurx += x;
    PG_OUT_TEXT(s);
    if (dev->type_index == TEXT_WINDOW_DEVICE)
       strcat(dev->text_buffer[dev->line_no], s);
 
    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_NEXT_LINE - do a controlled newline */
 
static void _PG_bgi_next_line(dev)
   PG_device *dev;
   {PG_text_box *b;
 
    b = (PG_text_box *) (dev->interface_objects[0]->obj);
    (*b->newline)(b);

    return;}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
 
/* _PG_BGI_FGETS - do fgets in a graphical environment 
 *               - primarily for PC type machines with only one window in which
 *               - to do both graphics and terminal I/O
 */
 
static char *_PG_bgi_fgets(buffer, maxlen, stream)
   char *buffer;
   int maxlen;
   FILE *stream;
   {PG_text_box *b;
 
    b = (PG_text_box *) (dev->interface_objects[0]->obj);
    return((*b->gets)(b, buffer, maxlen, stream));}
 
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/

/* _PG_BGI_QUERY_POINTER - query the pointer for location and button status */

static void _PG_bgi_query_pointer(dev, px, py, pb)
   PG_device *dev;
   int *px, *py, *pb;
   {int ret;
    PG_mouse_location *ms;

    ms = PG_get_mouse_position();
    if (ms != NULL)
       {*px = ms->x;
        *py = ms->y;
        *pb = ms->button;

        return(TRUE);}

    esle
       return(FALSE);}

/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
