/*
 * Copyright (c) 1999 The University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * Contributed by the Computer Security Research division,
 * INFOSEC Research and Technology Office, NSA.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
#define CONFIG_FLASK 1
#define CONFIG_FLASK_AUDIT 1
#undef CONFIG_FLASK_NOTIFY

#define MALLOC(size) malloc(size)
#define FREE(ptr,size) free(ptr)
#define REALLOC(ptr,oldsize,newsize) realloc(ptr,newsize)

#include <flask/flask.h>

typedef oskit_security_context_t security_context_t;
typedef oskit_security_econtext_t security_econtext_t;
typedef oskit_security_id_t security_id_t;
typedef oskit_access_vector_t access_vector_t;
typedef oskit_security_class_t security_class_t;

#define SECSID_NULL OSKIT_SECSID_NULL

#ifndef __KERNEL__

#include <stdio.h> 
#include <stdlib.h> 
#include <unistd.h> 
#include <string.h> 
#include <ctype.h> 
#include <limits.h>
#include <errno.h>
#include <sys/types.h>

#else

#include <oskit/fs/openfile.h>
#include <oskit/c/ctype.h>

int oskit_security_avc_ss_reset(oskit_u32_t seqno);
#define avc_ss_reset(seqno) oskit_security_avc_ss_reset(seqno)

int sprintf(char *__dest, const char *__format, ...);

void *oskit_security_malloc(unsigned size);
void oskit_security_free(void *addr);
void *oskit_security_realloc(void *addr, unsigned size);
int oskit_security_printf(const char * fmt, ...);
void oskit_security_panic(const char * fmt, ...);

#define malloc(size) oskit_security_malloc(size)
#define free(addr) oskit_security_free(addr)
#define printf(fmt...) oskit_security_printf(##fmt)
#define panic(fmt...) oskit_security_panic(##fmt)
#define realloc(addr,newsize) oskit_security_realloc(addr,newsize)

typedef struct oskit_openfile FILE;

extern inline oskit_u32_t fread(void *buf, oskit_u32_t size, oskit_u32_t nitems, FILE *stream)
{
	oskit_u32_t nbytes;
	oskit_error_t error;
	
	error = oskit_openfile_read(stream, buf, nitems*size, &nbytes);
	if (error)
		return -1;

	return nbytes;
}

#define EOF -1
extern inline int fgetc(FILE *stream)
{
	int c;
	oskit_u32_t bytes;
	bytes =  fread((void*)&c,1,1,stream);
	if (!bytes)
	  return EOF;
	else
	  return c;
}
#define getc(stream) fgetc(stream)

#define ferror(stream) 0
#define fileno(filep) 0

#define stdin  NULL
#define stdout NULL
#define stderr NULL

#define fprintf(stream, args...) printf(args)
#define fwrite(buf, size, nitems, fptr) printf(buf)

extern inline int yywrap(void)
{
    return 1;
}
 
extern inline int isatty(int fd)
{
    return 0;
}

#define exit(error_code) panic("SS: exiting (%d)",error_code)

#define ENOMEM (-OSKIT_ENOMEM) 
#define EEXIST (-OSKIT_EEXIST)
#define ENOENT (-OSKIT_ENOENT)
#define EINVAL (-OSKIT_EINVAL)

#ifndef NULL
#define NULL 0
#endif


/* 
 nm liboskit_security.a | grep '[TDRC]' | grep -v oskit_ | awk '{ printf("#define %s oskit_security_%s\n", $3, $3);}' | sort 
 */

#define avdeftab_destroy oskit_security_avdeftab_destroy
#define avdeftab_init oskit_security_avdeftab_init
#define avdeftab_insert oskit_security_avdeftab_insert
#define avdeftab_map oskit_security_avdeftab_map
#define avdeftab_search oskit_security_avdeftab_search
#define avtab_destroy oskit_security_avtab_destroy
#define avtab_hash_eval oskit_security_avtab_hash_eval
#define avtab_init oskit_security_avtab_init
#define avtab_insert oskit_security_avtab_insert
#define avtab_map oskit_security_avtab_map
#define avtab_search oskit_security_avtab_search
#define constraint_expr_destroy oskit_security_constraint_expr_destroy
#define context_cmp oskit_security_context_cmp
#define context_cpy oskit_security_context_cpy
#define context_destroy oskit_security_context_destroy
#define context_init oskit_security_context_init
#define ebitmap_cmp oskit_security_ebitmap_cmp
#define ebitmap_contains oskit_security_ebitmap_contains
#define ebitmap_cpy oskit_security_ebitmap_cpy
#define ebitmap_destroy oskit_security_ebitmap_destroy
#define ebitmap_get_bit oskit_security_ebitmap_get_bit
#define ebitmap_or oskit_security_ebitmap_or
#define ebitmap_set_bit oskit_security_ebitmap_set_bit
#define ext_create_buffer oskit_security_ext_create_buffer
#define ext_delete_buffer oskit_security_ext_delete_buffer
#define ext_flush_buffer oskit_security_ext_flush_buffer
#define ext_init_buffer oskit_security_ext_init_buffer
#define ext_load_buffer_state oskit_security_ext_load_buffer_state
#define ext_scan_buffer oskit_security_ext_scan_buffer
#define ext_scan_bytes oskit_security_ext_scan_bytes
#define ext_scan_string oskit_security_ext_scan_string
#define ext_switch_to_buffer oskit_security_ext_switch_to_buffer
#define extavtab oskit_security_extavtab
#define extavtab_init oskit_security_extavtab_init
#define extchar oskit_security_extchar
#define extcheck oskit_security_extcheck
#define extdebug oskit_security_extdebug
#define extdefred oskit_security_extdefred
#define extdgoto oskit_security_extdgoto
#define extension_errors oskit_security_extension_errors
#define exterrflag oskit_security_exterrflag
#define exterror oskit_security_exterror
#define extgindex oskit_security_extgindex
#define extin oskit_security_extin
#define extlen oskit_security_extlen
#define extleng oskit_security_extleng
#define extlex oskit_security_extlex
#define extlhs oskit_security_extlhs
#define extlval oskit_security_extlval
#define extnerrs oskit_security_extnerrs
#define extout oskit_security_extout
#define extparse oskit_security_extparse
#define extrestart oskit_security_extrestart
#define extrindex oskit_security_extrindex
#define extsindex oskit_security_extsindex
#define extss oskit_security_extss
#define extssp oskit_security_extssp
#define exttable oskit_security_exttable
#define exttext oskit_security_exttext
#define exttrtab oskit_security_exttrtab
#define exttrtab_init oskit_security_exttrtab_init
#define extval oskit_security_extval
#define extvs oskit_security_extvs
#define extvsp oskit_security_extvsp
#define extwrap oskit_security_extwrap
#define hashtab_create oskit_security_hashtab_create
#define hashtab_destroy oskit_security_hashtab_destroy
#define hashtab_insert oskit_security_hashtab_insert
#define hashtab_map oskit_security_hashtab_map
#define hashtab_map_remove_on_error oskit_security_hashtab_map_remove_on_error
#define hashtab_remove oskit_security_hashtab_remove
#define hashtab_replace oskit_security_hashtab_replace
#define hashtab_search oskit_security_hashtab_search
#define id_queue oskit_security_id_queue
#define invalidate_child oskit_security_invalidate_child
#define parent_info oskit_security_parent_info
#define policydb oskit_security_policydb
#define policydb_destroy oskit_security_policydb_destroy
#define policydb_errors oskit_security_policydb_errors
#define policydb_init oskit_security_policydb_init
#define policydb_transform oskit_security_policydb_transform
#define policydbp oskit_security_policydbp
#define progname oskit_security_progname
#define prvavtab_init oskit_security_prvavtab_init
#define queue_create oskit_security_queue_create
#define queue_destroy oskit_security_queue_destroy
#define queue_head oskit_security_queue_head
#define queue_insert oskit_security_queue_insert
#define queue_map oskit_security_queue_map
#define queue_map_remove_on_error oskit_security_queue_map_remove_on_error
#define queue_push oskit_security_queue_push
#define queue_remove oskit_security_queue_remove
#define root_context_cpy oskit_security_root_context_cpy
#define security_compute_av oskit_security_security_compute_av
#define security_context_to_sid oskit_security_security_context_to_sid
#define security_econtext_to_sid oskit_security_security_econtext_to_sid
#define security_load_extension oskit_security_security_load_extension
#define security_load_policy oskit_security_security_load_policy
#define security_member_sid oskit_security_security_member_sid
#define security_sid_to_context oskit_security_security_sid_to_context
#define security_sid_to_econtext oskit_security_security_sid_to_econtext
#define security_transition_sid oskit_security_security_transition_sid
#define sidtab oskit_security_sidtab
#define sidtab_init oskit_security_sidtab_init
#define sidtab_insert oskit_security_sidtab_insert
#define sidtab_map oskit_security_sidtab_map
#define sidtab_map_remove_on_error oskit_security_sidtab_map_remove_on_error
#define sidtab_remove oskit_security_sidtab_remove
#define sidtab_search oskit_security_sidtab_search
#define sidtab_context_to_sid oskit_security_sidtab_context_to_sid
#define ss_initialized oskit_security_ss_initialized
#define ss_root_context_valid oskit_security_ss_root_context_valid
#define symtab_init oskit_security_symtab_init
#define trtab_init oskit_security_trtab_init
#define yytext_ptr oskit_security_yytext_ptr

#endif
