/*
 * Copyright (c) 1996-1998 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */
#include <oskit/c/stdio.h>
#include "ether.h"

/* The arptable is maintained in host order. */
struct arptable_t arptable[MAX_ARP];

char ether_bcast[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

void
_dumparptable(char *file, int line)
{
	unsigned long addr;
	unsigned char *node;

#define DOIT(x)	\
	addr = arptable[x].ipaddr; \
	node = arptable[x].node; \
	printf("%20s {%ld.%ld.%ld.%ld, %x:%x:%x:%x:%x:%x}\n", \
		#x, \
	       (addr>>24)&0xff, (addr>>16)&0xff, (addr>>8)&0xff, addr&0xff, \
	       node[0], node[1], node[2], node[3], node[4], node[5]);

	printf("%s:%d -- arptable dump\n", file, line);
	DOIT(ARP_CLIENT);
	DOIT(ARP_GATEWAY);
	DOIT(ARP_NS);
	DOIT(ARP_ROOTSERVER);
	DOIT(ARP_SWAPSERVER);
	printf("-- end --\n");
#undef DOIT
}
