/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1998 David Baum.
 * All Rights Reserved.
 */


#include <stdio.h>
#include <ctype.h>
#include "RCX_Image.h"
#include "RCX_Disasm.h"

#define VERSION "1.0 b4"

void PrintUsage();
int ProcessCommandLine(int argc, char **argv);

const char *gFilename = nil;

static char *sTestArgs[]={"rcxdis", "test.rcx"};

int main(int argc, char **argv)
{
	RCX_Image image;
	RCX_Result result;
	
	if (argc == 0)
	{
		argv = sTestArgs;
		argc = sizeof(sTestArgs) / sizeof(char *);
	}

	if (!ProcessCommandLine(argc, argv))
	{
		PrintUsage();
		return -1;
	}

	result = image.Read(gFilename);
	if (result < 0)
	{
		switch(result)
		{
			case kRCX_FileError:
				fprintf(stderr, "Error: Could not open \'%s\'\n", gFilename);
				break;
			case kRCX_FormatError:
				fprintf(stderr, "Error: \'%s\' is not an RCXI file\n", gFilename);
				break;
			default:
				fprintf(stderr, "Error #%d\n", -result);
				break;
		}
		return -1;
	}

	image.Print();
	
	return 0;
}


void PrintUsage()
{
	fprintf(stderr,"rcxdis version "VERSION" (built "__DATE__"," __TIME__")\n");
	fprintf(stderr,"     written by Dave Baum\n");
	fprintf(stderr,"Usage: rcxdis filename\n");
}


int ProcessCommandLine(int argc, char **argv)
{
	for(int i=1; i<argc; i++)
	{
		if (argv[i][0]=='-')
		{
			switch(tolower(argv[i][1]))
			{
				default:
					return 0;
			}
		}
		else if (!gFilename)
			gFilename = argv[i];
		else
			return 0;
	}
	
	return gFilename ? true : false;
}
