/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Initial Developer of this code is David Baum.
 * Portions created by David Baum are Copyright (C) 1999 David Baum.
 * All Rights Reserved.
 */

#ifndef __CallStmt_h
#define __CallStmt_h

#ifndef __Stmt_h
#include "Stmt.h"
#endif

#ifndef __parser_h
#include "parser.h"
#endif

#ifndef __PArray_h
#include "PArray.h"
#endif

class Symbol;
class Clause;
class VarPool;

class CallStmt : public Stmt
{
public:
			CallStmt();
			~CallStmt();
	
	bool		Check(CheckState &state);
	void		Emit(Bytecode &b);
	CallStmt*	Clone(Mapping *b) const;

	void	SetName(const Symbol *name)	{ fName = name; }
	void	SetLocation(const struct LexLocation &loc)	{ fLocation = loc; }
	void	AddParam(Clause *c)			{ fParams.Append(c); }
	
private:
	bool	ExpandFunction(Function *f, VarPool *varPool);

	const Symbol*	fName;
	struct LexLocation fLocation;
	Stmt*	fStmt;
	PArray<Clause*>	fParams;
};

#endif
