/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.JCheckBox;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.SwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class CanOptions
extends JFrame
implements ActionListener,
ItemListener {
    ClogDisplay parent;
    private JCheckBox elTLineChkBox;
    private JCheckBox zoomLkLineChkBox;
    private MyTextField nFacField;
    private MyTextField zFacField;
    private MyTextField fromField;
    private MyTextField toField;
    private JTabbedPane tabbedP;
    private JComboBox dChoiceBox;
    private JComboBox dSelectedBox;

    public CanOptions(ClogDisplay clogDisplay) {
        super("Options");
        this.parent = clogDisplay;
        this.setup();
    }

    private void setup() {
        this.setupPanels();
        this.setupEventHandlers();
        ((Window)((Object)this)).pack();
        this.makeSize();
    }

    private void setupPanels() {
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 16;
        this.tabbedP = new JTabbedPane();
        JPanel jPanel = new JPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)new JLabel("Zoom Factor "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.zFacField = new MyTextField("", 5, true);
        jPanel.add((Component)((Object)this.zFacField), gridBagConstraints);
        this.zFacField.setToolTipText("This value is multiplied or divided with length of display during zooming");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel("Starting and ending times in viewport"), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("From "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.fromField = new MyTextField("", 10, true);
        jPanel.add((Component)((Object)this.fromField), gridBagConstraints);
        this.fromField.setToolTipText("starting time");
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)new JLabel("sec"), gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("To "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.toField = new MyTextField("", 10, true);
        jPanel.add((Component)((Object)this.toField), gridBagConstraints);
        this.toField.setToolTipText("ending time");
        gridBagConstraints.gridx = 2;
        jPanel.add((Component)new JLabel("sec"), gridBagConstraints);
        this.tabbedP.add("Zoom & Time", (Component)jPanel);
        JPanel jPanel2 = new JPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel2.add((Component)new JLabel("Nest Factor "), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.nFacField = new MyTextField("", 10, true);
        jPanel2.add((Component)((Object)this.nFacField), gridBagConstraints);
        this.nFacField.setToolTipText("This value defines difference in height between successive nested levels");
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)((Object)new MyButton("Do optimal nesting", "Do nesting using optimal nest factor", this)), gridBagConstraints);
        this.tabbedP.add("Nesting", (Component)jPanel2);
        JPanel jPanel3 = new JPanel((LayoutManager)new GridBagLayout());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.elTLineChkBox = new JCheckBox("Elapsed Time Line Display");
        jPanel3.add((Component)this.elTLineChkBox, gridBagConstraints);
        this.elTLineChkBox.addItemListener((ItemListener)this);
        this.elTLineChkBox.setToolTipText("Enable or disable display of elapsed time line");
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)((Object)new MyButton("Reset Elapsed Time", "Reset elapsed time line to 0", this)), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        this.zoomLkLineChkBox = new JCheckBox("Zoom Lock Line Display");
        jPanel3.add((Component)this.zoomLkLineChkBox, gridBagConstraints);
        this.zoomLkLineChkBox.addItemListener((ItemListener)this);
        this.zoomLkLineChkBox.setToolTipText("Enable or disable display of zoom lock line");
        this.tabbedP.add("Line Display", (Component)jPanel3);
        JPanel jPanel4 = new JPanel((LayoutManager)new GridBagLayout());
        MyJPanel myJPanel = new MyJPanel(new GridBagLayout(), "Display Choices");
        this.dChoiceBox = new JComboBox((Object[])CONST.DSTR);
        this.dChoiceBox.setSelectedIndex(0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        ((Container)((Object)myJPanel)).add((Component)this.dChoiceBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Container)((Object)myJPanel)).add((Component)((Object)new MyButton("Add", "Add selected Display Item", this)), gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        jPanel4.add((Component)((Object)myJPanel), gridBagConstraints);
        myJPanel = new MyJPanel(new GridBagLayout(), "Selected Displays");
        this.dSelectedBox = new JComboBox();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        ((Container)((Object)myJPanel)).add((Component)this.dSelectedBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        ((Container)((Object)myJPanel)).add((Component)((Object)new MyButton("Cut", "Cut selected Display Item", this)), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        jPanel4.add((Component)((Object)myJPanel), gridBagConstraints);
        this.tabbedP.add("Display Options", (Component)jPanel4);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.tabbedP, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        this.getContentPane().add((Component)((Object)new MyButton("Close", "Close window", this)), gridBagConstraints);
    }

    private void setupEventHandlers() {
        this.zFacField.addActionListener(this);
        this.zFacField.setActionCommand("Change zFac");
        this.fromField.addActionListener(this);
        this.fromField.setActionCommand("Change from");
        this.toField.addActionListener(this);
        this.toField.setActionCommand("Change to");
        this.nFacField.addActionListener(this);
        this.nFacField.setActionCommand("Change nFac");
        ((Window)((Object)this)).addWindowListener(new 1());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            ((Component)((Object)this)).setVisible(false);
            return;
        }
        if (string.equals("Reset Elapsed Time")) {
            this.parent.canvas.fixElTimePointer(0.0);
            return;
        }
        if (string.equals("Change nFac")) {
            double d;
            try {
                d = new Double(this.nFacField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid floating point value required");
                return;
            }
            this.parent.canvas.changeNestFactor(d);
            return;
        }
        if (string.equals("Do optimal nesting")) {
            this.nFacField.setText(new Float(this.parent.canvas.doAppropNesting()).toString());
            return;
        }
        if (string.equals("Change zFac")) {
            double d;
            try {
                d = new Double(this.zFacField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid floating point value required");
                return;
            }
            this.parent.canvas.changeZoomFactor(d);
            return;
        }
        if (string.equals("Change from")) {
            double d;
            try {
                d = new Double(this.fromField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid floating point value required");
                return;
            }
            this.parent.canvas.changeFromTime(d);
            return;
        }
        if (string.equals("Change to")) {
            double d;
            try {
                d = new Double(this.toField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                new ErrorDiag((Component)((Object)this), "Valid floating point value required");
                return;
            }
            this.parent.canvas.changeToTime(d);
            return;
        }
        if (string.equals("Add")) {
            int n = this.dChoiceBox.getSelectedIndex();
            this.parent.canvas.addDisplay(n);
            this.dSelectedBox.addItem((Object)CONST.DSTR[n]);
            return;
        }
        if (string.equals("Cut")) {
            if (this.dSelectedBox.getItemCount() < 2) {
                return;
            }
            int n = this.dSelectedBox.getSelectedIndex();
            this.parent.canvas.removeDisplay(n);
            this.dSelectedBox.removeItemAt(n);
            this.dSelectedBox.setSelectedIndex(0);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.elTLineChkBox) {
            this.parent.canvas.updateElTLineDStat(this.elTLineChkBox.isSelected());
            return;
        }
        this.parent.canvas.updateZLkLineDStat(this.zoomLkLineChkBox.isSelected());
    }

    public void reset() {
        this.elTLineChkBox.setSelected(this.parent.canvas.getZLkLineDStat());
        this.zoomLkLineChkBox.setSelected(this.parent.canvas.getElTLineDStat());
        this.nFacField.setText(new Float(this.parent.canvas.nestFactor).toString());
        this.zFacField.setText(new Float(this.parent.canvas.zF).toString());
        if (this.parent.canvas.maxLevel == 0) {
            this.tabbedP.setEnabledAt(this.tabbedP.indexOfTab("Nesting"), false);
        }
        this.makeSize();
    }

    void addDisplay(int n) {
        this.dSelectedBox.addItem((Object)CONST.DSTR[n]);
    }

    void adjustTimes(double d, double d2) {
        this.fromField.setText(new Float(d).toString());
        this.toField.setText(new Float(d2).toString());
    }

    private void makeSize() {
        ((Frame)((Object)this)).setResizable(true);
        Dimension dimension = ((Container)((Object)this)).getMinimumSize();
        dimension.height += 40;
        dimension.width += 40;
        ((Component)((Object)this)).setSize(dimension);
    }

    void makeUIChanges() {
        SwingUtilities.updateComponentTreeUI((Component)((Object)this));
        this.makeSize();
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)((Object)CanOptions.this)).setVisible(false);
        }

        /* synthetic */ 1() {
        }
    }
}

