/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.tree;

import com.sun.java.swing.DefaultListSelectionModel;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.tree.PathPlaceHolder;
import com.sun.java.swing.tree.RowMapper;
import com.sun.java.swing.tree.TreePath;
import com.sun.java.swing.tree.TreeSelectionModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Vector;

public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected PropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList = new EventListenerList();
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel = new DefaultListSelectionModel();
    protected int selectionMode = 4;
    protected TreePath leadPath;
    protected int leadIndex = -1;
    protected int leadRow = -1;
    static /* synthetic */ Class class$com$sun$java$swing$event$TreeSelectionListener;

    public void setRowMapper(RowMapper rowMapper) {
        this.rowMapper = rowMapper;
        this.resetRowSelection();
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setSelectionMode(int n) {
        int n2 = this.selectionMode;
        this.selectionMode = n;
        if (this.selectionMode != 1 && this.selectionMode != 2 && this.selectionMode != 4) {
            this.selectionMode = 4;
        }
        if (n2 != this.selectionMode && this.changeSupport != null) {
            this.changeSupport.firePropertyChange(SELECTION_MODE_PROPERTY, new Integer(n2), new Integer(this.selectionMode));
        }
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionPath(TreePath treePath) {
        if (treePath == null) {
            this.setSelectionPaths(null);
            return;
        }
        TreePath[] treePathArray = new TreePath[]{treePath};
        this.setSelectionPaths(treePathArray);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        int n;
        TreePath[] treePathArray2 = treePathArray;
        int n2 = treePathArray2 == null ? 0 : treePathArray2.length;
        if (n2 + (n = this.selection == null ? 0 : this.selection.length) != 0) {
            int n3;
            if (this.selectionMode == 1) {
                if (n2 > 1) {
                    treePathArray2 = new TreePath[]{treePathArray[0]};
                    n2 = 1;
                }
            } else if (this.selectionMode == 2 && n2 > 0 && !this.arePathsContiguous(treePathArray2)) {
                treePathArray2 = new TreePath[]{treePathArray[0]};
                n2 = 1;
            }
            int n4 = 0;
            TreePath treePath = this.leadPath;
            Vector<PathPlaceHolder> vector = new Vector<PathPlaceHolder>(n2 + n);
            this.leadPath = null;
            int n5 = 0;
            while (n5 < n2) {
                boolean bl = false;
                if (treePathArray2[n5] != null) {
                    ++n4;
                    n3 = 0;
                    while (n3 < n) {
                        if (this.selection[n3] != null && this.selection[n3].equals(treePathArray2[n5])) {
                            this.selection[n3] = null;
                            n3 = n;
                            bl = true;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        vector.addElement(new PathPlaceHolder(treePathArray2[n5], true));
                    }
                    if (this.leadPath == null) {
                        this.leadPath = treePathArray2[n5];
                    }
                }
                ++n5;
            }
            n3 = 0;
            while (n3 < n) {
                if (this.selection[n3] != null) {
                    vector.addElement(new PathPlaceHolder(this.selection[n3], false));
                }
                ++n3;
            }
            if (n4 == 0) {
                this.selection = null;
            } else if (n4 != n2) {
                this.selection = new TreePath[n4];
                n5 = 0;
                n4 = 0;
                while (n5 < n2) {
                    if (treePathArray2[n5] != null) {
                        this.selection[n4++] = treePathArray2[n5];
                    }
                    ++n5;
                }
            } else {
                this.selection = new TreePath[treePathArray2.length];
                System.arraycopy(treePathArray2, 0, this.selection, 0, treePathArray2.length);
            }
            if (this.selection != null) {
                this.insureUniqueness();
            }
            this.updateLeadIndex();
            this.resetRowSelection();
            if (vector.size() > 0) {
                this.notifyPathChange(vector, treePath);
            }
        }
    }

    public void addSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.addSelectionPaths(treePathArray);
        }
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        int n;
        int n2 = n = treePathArray == null ? 0 : treePathArray.length;
        if (n > 0) {
            TreePath[] treePathArray2;
            if (this.selectionMode == 1 && this.selection != null && this.selection.length > 0) {
                this.setSelectionPaths(treePathArray);
                return;
            }
            if (this.selectionMode == 2 && !this.canPathsBeAdded(treePathArray)) {
                if (this.arePathsContiguous(treePathArray)) {
                    this.setSelectionPaths(treePathArray);
                    return;
                }
                TreePath[] treePathArray3 = new TreePath[]{treePathArray[0]};
                this.setSelectionPaths(treePathArray3);
                return;
            }
            TreePath treePath = this.leadPath;
            Vector<PathPlaceHolder> vector = null;
            int n3 = this.selection == null ? 0 : this.selection.length;
            boolean bl = false;
            this.leadPath = null;
            int n4 = 0;
            int n5 = 0;
            while (n4 < treePathArray.length) {
                if (treePathArray[n4] != null) {
                    boolean bl2 = false;
                    int n6 = 0;
                    while (n6 < n3) {
                        if (treePathArray[n4].equals(this.selection[n6])) {
                            n6 = n3;
                            if (!bl) {
                                treePathArray2 = new TreePath[treePathArray.length];
                                System.arraycopy(treePathArray, 0, treePathArray2, 0, treePathArray.length);
                                treePathArray = treePathArray2;
                                bl = true;
                            }
                            treePathArray[n4] = null;
                            bl2 = true;
                        }
                        ++n6;
                    }
                    if (!bl2) {
                        ++n5;
                        if (vector == null) {
                            vector = new Vector<PathPlaceHolder>();
                        }
                        vector.addElement(new PathPlaceHolder(treePathArray[n4], true));
                    }
                    if (this.leadPath == null) {
                        this.leadPath = treePathArray[n4];
                    }
                }
                ++n4;
            }
            if (this.leadPath == null) {
                this.leadPath = treePath;
            }
            if (n5 > 0) {
                treePathArray2 = new TreePath[n3 + n5];
                if (n3 > 0) {
                    System.arraycopy(this.selection, 0, treePathArray2, 0, n3);
                }
                if (n5 != treePathArray.length) {
                    int n7 = 0;
                    n4 = 0;
                    while (n4 < treePathArray.length) {
                        if (treePathArray[n4] != null) {
                            treePathArray2[n3 + n7++] = treePathArray[n4];
                        }
                        ++n4;
                    }
                } else {
                    System.arraycopy(treePathArray, 0, treePathArray2, n3, n5);
                }
                this.selection = treePathArray2;
                this.insureUniqueness();
                this.updateLeadIndex();
                this.resetRowSelection();
                this.notifyPathChange(vector, treePath);
                return;
            }
            this.leadPath = treePath;
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        if (treePath != null) {
            TreePath[] treePathArray = new TreePath[]{treePath};
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null && this.selection != null && treePathArray.length > 0) {
            int n;
            if (!this.canPathsBeRemoved(treePathArray)) {
                this.clearSelection();
                return;
            }
            TreePath treePath = this.leadPath;
            Vector<PathPlaceHolder> vector = null;
            int n2 = this.selection.length;
            int n3 = 0;
            while (n3 < treePathArray.length) {
                if (treePathArray[n3] != null) {
                    if (this.leadPath != null && this.leadPath.equals(treePathArray[n3])) {
                        this.leadPath = null;
                    }
                    n = 0;
                    while (n < n2) {
                        if (treePathArray[n3].equals(this.selection[n])) {
                            this.selection[n] = null;
                            n = n2;
                            if (vector == null) {
                                vector = new Vector<PathPlaceHolder>(treePathArray.length);
                            }
                            if (!vector.contains(treePathArray[n3])) {
                                vector.addElement(new PathPlaceHolder(treePathArray[n3], false));
                            }
                        }
                        ++n;
                    }
                }
                ++n3;
            }
            if (vector != null) {
                int n4 = vector.size();
                if (n4 == this.selection.length) {
                    this.selection = null;
                } else {
                    int n5 = 0;
                    TreePath[] treePathArray2 = new TreePath[this.selection.length - n4];
                    n = 0;
                    while (n < n2) {
                        if (this.selection[n] != null) {
                            treePathArray2[n5++] = this.selection[n];
                        }
                        ++n;
                    }
                    this.selection = treePathArray2;
                }
                if (this.leadPath == null && this.selection != null) {
                    this.leadPath = this.selection[0];
                }
                this.updateLeadIndex();
                this.resetRowSelection();
                this.notifyPathChange(vector, treePath);
            }
        }
    }

    public TreePath getSelectionPath() {
        if (this.selection != null) {
            return this.selection[0];
        }
        return null;
    }

    public TreePath[] getSelectionPaths() {
        if (this.selection != null) {
            int n = this.selection.length;
            TreePath[] treePathArray = new TreePath[n];
            System.arraycopy(this.selection, 0, treePathArray, 0, n);
            return treePathArray;
        }
        return null;
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    public boolean isPathSelected(TreePath treePath) {
        if (this.selection != null) {
            int n = 0;
            while (n < this.selection.length) {
                if (this.selection[n].equals(treePath)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        return this.selection == null;
    }

    public void clearSelection() {
        if (this.selection != null) {
            int n = this.selection.length;
            boolean[] blArray = new boolean[n];
            int n2 = 0;
            while (n2 < n) {
                blArray[n2] = false;
                ++n2;
            }
            TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, this.selection, blArray, this.leadPath, null);
            this.leadPath = null;
            this.leadRow = -1;
            this.leadIndex = -1;
            this.selection = null;
            this.resetRowSelection();
            this.fireValueChanged(treeSelectionEvent);
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : (class$com$sun$java$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("com.sun.java.swing.event.TreeSelectionListener")), treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : (class$com$sun$java$swing$event$TreeSelectionListener = DefaultTreeSelectionModel.class$("com.sun.java.swing.event.TreeSelectionListener")), treeSelectionListener);
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeSelectionListener != null ? class$com$sun$java$swing$event$TreeSelectionListener : DefaultTreeSelectionModel.class$("com.sun.java.swing.event.TreeSelectionListener"))) {
                ((TreeSelectionListener)objectArray[n + 1]).valueChanged(treeSelectionEvent);
            }
            n -= 2;
        }
    }

    public int[] getSelectionRows() {
        if (this.rowMapper != null && this.selection != null) {
            return this.rowMapper.getRowsForPaths(this.selection);
        }
        return null;
    }

    public int getMinSelectionRow() {
        return this.listSelectionModel.getMinSelectionIndex();
    }

    public int getMaxSelectionRow() {
        return this.listSelectionModel.getMaxSelectionIndex();
    }

    public boolean isRowSelected(int n) {
        return this.listSelectionModel.isSelectedIndex(n);
    }

    public void resetRowSelection() {
        this.listSelectionModel.clearSelection();
        if (this.selection != null && this.rowMapper != null) {
            int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
            int n = 0;
            int n2 = this.selection.length;
            while (n < n2) {
                int n3 = nArray[n];
                if (n3 != -1) {
                    this.listSelectionModel.addSelectionInterval(n3, n3);
                }
                ++n;
            }
            if (this.leadIndex != -1) {
                this.leadRow = nArray[this.leadIndex];
            }
            this.insureRowContinuity();
            return;
        }
        this.leadRow = -1;
    }

    public int getLeadSelectionRow() {
        return this.leadRow;
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void insureRowContinuity() {
        if (this.selectionMode == 2 && this.selection != null && this.rowMapper != null) {
            DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
            int n = defaultListSelectionModel.getMinSelectionIndex();
            if (n != -1) {
                int n2 = n;
                int n3 = defaultListSelectionModel.getMaxSelectionIndex();
                while (n2 <= n3) {
                    if (!defaultListSelectionModel.isSelectedIndex(n2)) {
                        if (n2 == n) {
                            this.clearSelection();
                        } else {
                            TreePath[] treePathArray = new TreePath[n2 - n];
                            System.arraycopy(this.selection, 0, treePathArray, 0, n2 - n);
                            this.setSelectionPaths(treePathArray);
                            return;
                        }
                    }
                    ++n2;
                }
                return;
            }
        } else if (this.selectionMode == 1 && this.selection != null && this.selection.length > 1) {
            this.setSelectionPath(this.selection[0]);
        }
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        if (this.rowMapper == null || treePathArray.length < 2) {
            return true;
        }
        BitSet bitSet = new BitSet(32);
        int n = treePathArray.length;
        int n2 = 0;
        TreePath[] treePathArray2 = new TreePath[]{treePathArray[0]};
        int n3 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        int n4 = 0;
        while (n4 < n) {
            if (treePathArray[n4] != null) {
                treePathArray2[0] = treePathArray[n4];
                int n5 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
                if (n5 == -1 || n5 < n3 - n || n5 > n3 + n) {
                    return false;
                }
                if (n5 < n3) {
                    n3 = n5;
                }
                if (!bitSet.get(n5)) {
                    bitSet.set(n5);
                    ++n2;
                }
            }
            ++n4;
        }
        int n6 = n2 + n3;
        n4 = n3;
        while (n4 < n6) {
            if (!bitSet.get(n4)) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        int n;
        if (treePathArray == null || treePathArray.length == 0 || this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        DefaultListSelectionModel defaultListSelectionModel = this.listSelectionModel;
        int n2 = defaultListSelectionModel.getMinSelectionIndex();
        int n3 = defaultListSelectionModel.getMaxSelectionIndex();
        TreePath[] treePathArray2 = new TreePath[1];
        if (n2 != -1) {
            n = n2;
            while (n <= n3) {
                if (defaultListSelectionModel.isSelectedIndex(n2)) {
                    bitSet.set(n);
                }
                ++n;
            }
        } else {
            treePathArray2[0] = treePathArray[0];
            n2 = n3 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
        }
        n = treePathArray.length - 1;
        while (n >= 0) {
            if (treePathArray[n] != null) {
                treePathArray2[0] = treePathArray[n];
                int n4 = this.rowMapper.getRowsForPaths(treePathArray2)[0];
                n2 = Math.min(n4, n2);
                n3 = Math.max(n4, n3);
                if (n4 == -1) {
                    return false;
                }
                bitSet.set(n4);
            }
            --n;
        }
        n = n2;
        while (n <= n3) {
            if (!bitSet.get(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        if (this.rowMapper == null || this.selection == null || this.selectionMode == 4) {
            return true;
        }
        BitSet bitSet = new BitSet();
        int n = treePathArray.length;
        int n2 = -1;
        int n3 = 0;
        TreePath[] treePathArray2 = new TreePath[n];
        TreePath[] treePathArray3 = new TreePath[1];
        System.arraycopy(treePathArray, 0, treePathArray2, 0, n);
        int n4 = this.selection.length - 1;
        while (n4 >= 0) {
            boolean bl = false;
            int n5 = 0;
            while (n5 < n) {
                if (treePathArray2[n5] != null && this.selection[n4].equals(treePathArray2[n5])) {
                    treePathArray2[n5] = null;
                    bl = true;
                    break;
                }
                ++n5;
            }
            if (!bl) {
                treePathArray3[0] = this.selection[n4];
                int n6 = this.rowMapper.getRowsForPaths(treePathArray3)[0];
                if (n6 != -1 && !bitSet.get(n6)) {
                    ++n3;
                    n2 = n2 == -1 ? n6 : Math.min(n2, n6);
                    bitSet.set(n6);
                }
            }
            --n4;
        }
        if (n3 > 1) {
            n4 = n2 + n3 - 1;
            while (n4 >= n2) {
                if (!bitSet.get(n4)) {
                    return false;
                }
                --n4;
            }
        }
        return true;
    }

    protected void notifyPathChange(Vector vector, TreePath treePath) {
        int n = vector.size();
        boolean[] blArray = new boolean[n];
        TreePath[] treePathArray = new TreePath[n];
        int n2 = 0;
        while (n2 < n) {
            PathPlaceHolder pathPlaceHolder = (PathPlaceHolder)vector.elementAt(n2);
            blArray[n2] = pathPlaceHolder.isNew;
            treePathArray[n2] = pathPlaceHolder.path;
            ++n2;
        }
        TreeSelectionEvent treeSelectionEvent = new TreeSelectionEvent((Object)this, treePathArray, blArray, treePath, this.leadPath);
        this.fireValueChanged(treeSelectionEvent);
    }

    protected void updateLeadIndex() {
        if (this.leadPath != null) {
            if (this.selection == null) {
                this.leadPath = null;
                this.leadRow = -1;
                this.leadIndex = -1;
                return;
            }
            this.leadIndex = -1;
            this.leadRow = -1;
            int n = this.selection.length - 1;
            while (n >= 0) {
                if (this.selection[n].equals(this.leadPath)) {
                    this.leadIndex = n;
                    return;
                }
                --n;
            }
        }
    }

    protected void insureUniqueness() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.selection.length) {
            if (this.selection[n2] != null) {
                int n3 = n2 + 1;
                while (n3 < this.selection.length) {
                    if (this.selection[n3] != null && this.selection[n2].equals(this.selection[n3])) {
                        ++n;
                        this.selection[n3] = null;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        if (n > 0) {
            TreePath[] treePathArray = new TreePath[this.selection.length - n];
            int n4 = 0;
            int n5 = 0;
            while (n4 < this.selection.length) {
                if (this.selection[n4] != null) {
                    treePathArray[n5++] = this.selection[n4];
                }
                ++n4;
            }
            this.selection = treePathArray;
        }
    }

    public String toString() {
        int n = this.getSelectionCount();
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = this.rowMapper != null ? this.rowMapper.getRowsForPaths(this.selection) : null;
        stringBuffer.append(String.valueOf(this.getClass().getName()) + " " + this.hashCode() + " [ ");
        int n2 = 0;
        while (n2 < n) {
            if (nArray != null) {
                stringBuffer.append(String.valueOf(this.selection[n2].toString()) + "@" + Integer.toString(nArray[n2]) + " ");
            } else {
                stringBuffer.append(String.valueOf(this.selection[n2].toString()) + " ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultTreeSelectionModel defaultTreeSelectionModel = (DefaultTreeSelectionModel)super.clone();
        defaultTreeSelectionModel.changeSupport = null;
        if (this.selection != null) {
            int n = this.selection.length;
            defaultTreeSelectionModel.selection = new TreePath[n];
            System.arraycopy(this.selection, 0, defaultTreeSelectionModel.selection, 0, n);
        }
        defaultTreeSelectionModel.listenerList = new EventListenerList();
        defaultTreeSelectionModel.listSelectionModel = (DefaultListSelectionModel)this.listSelectionModel.clone();
        return defaultTreeSelectionModel;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Object[] objectArray = this.rowMapper != null && this.rowMapper instanceof Serializable ? new Object[]{"rowMapper", this.rowMapper} : new Object[]{};
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        if (objectArray.length > 0 && objectArray[0].equals("rowMapper")) {
            this.rowMapper = (RowMapper)objectArray[1];
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

