open Gtk
open GtkObj
open GtkDrawing
open GtkEasy
open GtkEasy.Menu
open GtkEasy.Layout

(* A shorthand for a useful function ... *)
let soi = string_of_int

(* A text widget to let us know what is happening ... *)
let text = text_new ()
let mesg s = 
(
  text#freeze ();
  text#insert_text (s^"\n") ((String.length s)+1) 0;
  text#thaw ();
)

(* A drawingarea widget to play with *)
let current_color = ref white
let select_current_color col () = current_color := col
let do_b drawingarea x y button state = match button with
  | 1 -> fill_rect drawingarea !current_color x y 10 10
  | 2 ->
    let col = point_color drawingarea (x,y)
	 in mesg (Printf.sprintf "Col(%d,%d) = P=%d, R=%d, G=%d, B=%d"
		x y col.Gdk.pixel col.Gdk.red col.Gdk.green col.Gdk.blue)
  | 3 -> draw_string drawingarea default_font !current_color (x,y) "Hello"
  | _ -> ()
let do_m drawingarea x y is_hint state =
  if is_hint then
  let x,y,state = if is_hint
    then Gdk.window_get_pointer
      (Gtk.Unsafe.window_of drawingarea#get_gtkobject)
	 else x,y,state
  in (* Hack to remplace : state & GDK_BUTTON1_MASK *)
    if (state land (1 lsl 8)) > 0
    then fill_rect drawingarea !current_color x y 10 10
	 else if (state land (1 lsl 10)) > 0
	 then draw_string drawingarea default_font !current_color (x,y) "Hello"
let do_c drawingarea x y width height = mesg "configure"
let do_e drawingarea x y width height = mesg "expose"
let drawingarea = make_drawing_area do_c do_e do_b do_m empty_k 300 200
let clean_drawingarea () = clear_graph drawingarea

(* A menu *)
let mesgfunc t = function () -> mesg t
let menu_def =
[ 
  Submenu (Label "Tutorial 3",
  [
    Item (Label "About", mesgfunc
    	"A small Example of how to use GtkDrawing in mlgtk");
    Item (Label "Close", Gtk.main_quit)
  ]);
  Submenu (Label "Misc",
  [
    Item (Label "Options", mesgfunc "Not yet implemented.");
    Item (Label "Clean", clean_drawingarea);
  ]);
  Submenu (GtkEasy.Label "Color",
  [
    Item (GtkEasy.Label "Black", select_current_color
      GtkDrawing.black);
    Item (GtkEasy.Label "White", select_current_color
      GtkDrawing.white);
    Item (GtkEasy.Label "Red", select_current_color
      GtkDrawing.red);
    Item (GtkEasy.Label "Green", select_current_color
      GtkDrawing.green);
    Item (GtkEasy.Label "Blue", select_current_color
      GtkDrawing.blue);
    Item (GtkEasy.Label "Magenta", select_current_color
      GtkDrawing.magenta);
    Item (GtkEasy.Label "Yellow", select_current_color
      GtkDrawing.yellow);
    Item (GtkEasy.Label "Cyan", select_current_color
      GtkDrawing.cyan);
  ]);
  Item (Label "Help", mesgfunc "No help available yet.");
]
let menu_bar = make_menu_bar menu_def

(* Toplevel stuff ... *)
let structure =
  let me = Widget (menu_bar:>widget),
    {expand=false; fill=false; padding=1}  
  and da = Widget (drawingarea:>widget), Label "Drawing Area"
  and tx = Widget (text:>widget), Label "Log"
  in let nb = Notebook (POS_TOP, [tx; da]), 
    {expand=true; fill=true; padding=1}  
  in Box (Vert, [me; nb])

(* We create the toplevel window ... *)
let window = make_window_from_structure structure "Toplevel Window" ;;
  
(* The handler installed with the method [#connect_delete_event]
   is called when the user tries to close the window.  *)
let _ = window #connect_delete_event( fun () -> Gtk.main_quit(); false )

let main () =
(
  (* Show the window. *)
  window #show;
  (* And at last enter the event loop. *)
  GtkThr.main ();
)

let _ = main ()
