open GtkObj
open GtkEasy
open GtkEasy.Layout
open Gdk.Event
open Gdk.Event.Extract

(* On cree un widget texte pour afficher des messages,
   car il est impossible d'ecrire sur la sortie standard avec mlgtk *)
let text =text_new ()

(* Fonction permettant d'ecrire dans la zone texte *)
let write_mesg s =
  text#insert_text (s^"\n") ((String.length s)+1) 0 
let soi = string_of_int

(* Backing pixmap *)
let pixmap = ref None
(* Widget DrawingArea, ou nous allons pouvoir dessiner *)
let drawingarea = drawing_area_new ()

(* L'evenement configure a lieu au debut, et a chaque fois que le widget
   change de taille *)
let drawingarea_configure (x:Gtk.Unsafe.gtkArg list) =
(
	(* On recupere le widget gtk correspndant au drawingarea *)
	let da = drawingarea#get_gtkobject in
	(* On recupere la fenetre correspondante au widget drawing area *)
	let w = Gtk.Unsafe.window_of da
	(* on recupere le graphic context noir
	   se trouve dans le champ black_gc du champs style du widget *)
	and black_gc = let st = Gtk.Unsafe.style_of da in st.Gtk.black_gc
	(* on recupere l'allocation du widget *)
	and allocation = Gtk.Unsafe.allocation_of da
	(* hauteur et largeur de l'allocation ... *)
	in let width = allocation.Gtk.width
	and height = allocation.Gtk.height
	(* On alloue un nouveau GdkPixmap, si il n'etait pas deja alloue ...*)
	in let pm = match !pixmap with
		| None ->
			let p = Gdk.pixmap_new w width height (-1)
			in pixmap := Some p; p
		(* Note il vaudrais mieux faire un unref dessus, comme
		   je faisais avant, au cas ou la fenetre change de taille *)
		| Some p -> p
	(* On recupere le drawable du GdkPixmap *)
	in let d = Gdk.drawable_from_pixmap pm
	in
	(
		(* On peint en noir le GdkPixmap *)
		Gdk.draw_rectangle d black_gc true 0 0 width height;
		write_mesg "configure ...";
		(* Pourquoi fqut-il renvoyer true ?
		   en tout cas, il faut un bool *)
		Gtk.Unsafe.Bool true
	)
)

(* L'evenement expose a lieu apres chaque evenement configure,
   et chaque fois que le widget etait cache et reapparait. *)
let drawingarea_expose (x:Gtk.Unsafe.gtkArg list) =
(
	(* On recupere le widget gtk correspndant au drawingarea *)
	let da = drawingarea#get_gtkobject in
	(* On recupere les coordonnes de la zone qui apparait *)
	let (x, y, width, height) = (function Gtk.Unsafe.Pointer p ->
		expose_x p, expose_y p, expose_w p, expose_h p
		| _ -> (0, 0, 0, 0)) (List.hd x)
	(* On recupere la fenetre correspondante au widget drawing area *)
	and w = Gtk.Unsafe.window_of da
	(* on recupere le graphic context de front
	   se trouve dans le champ fg_gc[state_of da] du champs style
	   du widget *)
	and st = Gtk.Unsafe.style_of da
	in let fg_gc = st.Gtk.fg_gc.(Gtk.Unsafe.state_of da)
	(* On recupere le drawable du GdkPixmap *)
	and d = Gdk.drawable_from_window w
	(* On alloue un nouveau GdkPixmap, si il n'etait pas deja alloue ...*)
	and pm = match !pixmap with
		| None ->
			let p = Gdk.pixmap_new w width height (-1)
			in pixmap := Some p; p
		| Some p -> p
	in
	(
		(* on repeint la partie expose du GdkPixmap *)
		Gdk.draw_pixmap d fg_gc pm x y x y width height;
		write_mesg "expose ...";
		(* Pourquoi fqut-il renvoyer false ?
		   en tout cas, il faut un bool *)
		Gtk.Unsafe.Bool false
	)
)

(* On dessine un carre blanc a la position x,y *)
let draw_point x y =
	(* On recupere le widget gtk dans l'objet caml *)
	let da = drawingarea#get_gtkobject
	(* on recupere le drawable associe au widget *)
	in let w = Gtk.Unsafe.window_of da
	in let d = Gdk.drawable_from_window w
	(* On recupere le graphic context blanc associe au widget *)
	and st = Gtk.Unsafe.style_of da
	in let white = st.Gtk.white_gc
	(* puis on dessine un rectangle blanc dans ce drawable *)
	in Gdk.draw_rectangle d white true (x-5) (y-5) 10 10

(* On renvoie la couleur du pixel a la position x, y *)
let point_color x y =
	(* On recupere le widget gtk dans l'objet caml *)
	let da = drawingarea#get_gtkobject
	(* on recupere le drawable associe au widget *)
	in let w = Gtk.Unsafe.window_of da
	in let i = Gdk.image_get w 0 0 (x+1) (y+1)
	in let pixel = Gdk.image_get_pixel i x y
	in write_mesg ("Pixel ("^(soi x)^", "^(soi y)^") : "^(soi pixel))

(* Fonction qui affiche quel bouton (de souris) a ete presse, et
   a quels coordonnees. *)
let button_pressed b x y =
(
	write_mesg ("Bouton "^(soi b)^" presse aux coordonees ("^(soi x)^
		","^(soi y)^") ...");
	match b with
	| 1 -> draw_point x y
	| 2 -> point_color x y
	| _ -> ()
)

(* A chaque evenement click souris, on appelle la fonction button_pressed,
   avec comme argument le bouton presse (1, 2 ou 3) et les coordonnees *)
let drawingarea_button_pressed (x:Gtk.Unsafe.gtkArg list) =
(
	let (b, x, y) =
	(* On recupere la tete de la liste d'argument, qui contient un
	   pointeur sur un evenement gdk. On en extrait le button presse,
	   et les coordonnees *)
	( function
	  | Gtk.Unsafe.Pointer p -> button_button p, button_x p, button_y p
		| _ -> (-1, 0, 0)
	) (List.hd x)
	in button_pressed b x y;
	Gtk.Unsafe.Bool true
)

(* Notre widget va repondre aux evenements de BUTTON_PRESS et EXPOSURE *)
let _ = drawingarea#set_events [BUTTON_PRESS_MASK; EXPOSURE_MASK]
(* On associe nos event handlers a leur evenement respectifs *)
let _ = Gtk.Unsafe.signal_connect drawingarea#get_gtkobject "button_press_event" drawingarea_button_pressed
let _ = Gtk.Unsafe.signal_connect drawingarea#get_gtkobject "configure_event" drawingarea_configure
let _ = Gtk.Unsafe.signal_connect drawingarea#get_gtkobject "expose_event" drawingarea_expose
(* Nous definissons une taille initiale a notre drawingarea widget *)
let _ = drawingarea#size 300 200

(* Nous ajoutons un bouton de sortie *)
let quitbutton = button_new_with_label "Sortir"
let quithandle (x:Gtk.Unsafe.gtkArg list) =
	Gtk.main_quit (); Gtk.Unsafe.Unit
let _ = Gtk.Unsafe.signal_connect quitbutton#get_gtkobject "clicked" quithandle

(* Nous mettons ces trois boutons dans un boite verticale *)
let structure =
	let da =  Widget (drawingarea:>widget),
		{expand=true; fill=true; padding=1}	
	and but = Widget (quitbutton:>widget),
		{expand=false; fill=false; padding=1}
	and t = Widget (text:>widget),
		{expand=false; fill=false; padding=1}
	in Box (Vert, [da; but; t])

(* Nous creons la fenetre principale, qui contiendra nos widgets *)
let window = make_window_from_structure structure "Toplevel Window" ;;

(* Dans main on n'a plus qu'a montrer la fenetre *)
let main () = window #show

let _ = text#realize

let _ = main ()
