/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: rpstate.c,v 6.2 1999/05/26 21:50:02 kmeyer1 Exp $
 *
 *	Function:	- retrieves status of remote processes
 *	Accepts:	- remote node ID
 *			- process select flags
 *			- process select value
 *			- process state table
 *			- process state table # entries
 *	Returns:	- # retrieved process states or ERROR
 */

#include <unistd.h>

#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>

int4
rpstate(nodeid, sflags, svalue, pstable, maxproc)

int4			nodeid;
int4			sflags;
int4			svalue;
struct pstate		pstable[];
int4			maxproc;

{
	struct nmsg	nhead;		/* network nhead */
	struct preq	request;	/* kenya request */
	int4		nproc;		/* # replied states */
	int4		mask;		/* signal mask */
	int4		ret;		/* reply code */

	if (maxproc <= 0) {
		return(0);
	}

	nproc = 0;

	request.pq_sel_method = ltot(sflags);
	request.pq_sel_value = ltot(svalue);
	request.pq_req = ltot(PQSTATE);
	request.pq_maxproc = ltot(maxproc);
	request.pq_src_node = (nodeid == LOCAL) ?
			ltot(nodeid) : ltot(getnodeid());
	request.pq_src_event = ltot((int4) -getpid());

	nhead.nh_node = nodeid;
	nhead.nh_event = EVKENYAD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(request);
	nhead.nh_msg = (char *) &request;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -getpid();
	nhead.nh_length = sizeof(struct pstate);

	do {
		nhead.nh_msg = (char *) pstable;

		if (nrecv(&nhead)) {
			ksigsetmask(mask);
			return(ERROR);
		}
/*
 * Convert byte ordering (sigh).
 */
		pstable->ps_reply = ttol(pstable->ps_reply);
		pstable->ps_index = ttol(pstable->ps_index);
		pstable->ps_pid = ttol(pstable->ps_pid);
		pstable->ps_rtf = ttol(pstable->ps_rtf);
		pstable->ps_event = ttol(pstable->ps_event);
		pstable->ps_nodeid = ttol(pstable->ps_nodeid);
		pstable->ps_kernel.ks_state =
				ttol(pstable->ps_kernel.ks_state);
		pstable->ps_kernel.ks_priority =
				ttol(pstable->ps_kernel.ks_priority);
		pstable->ps_kernel.ks_event =
				ttol(pstable->ps_kernel.ks_event);
		pstable->ps_kernel.ks_type =
				ttol(pstable->ps_kernel.ks_type);
		pstable->ps_kernel.ks_signal =
				ttol(pstable->ps_kernel.ks_signal);

		ret = pstable->ps_reply;
		++nproc;
		++pstable;
	} while ((nproc < maxproc) && !ret);

	ksigsetmask(mask);
	if (ret) nproc--;
	return(nproc);
}
