/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: crsize.c,v 6.2 1999/05/25 22:07:49 kmeyer1 Exp $
 *
 *	Function:	- return the size of the remote group
 *	Accepts:	- inter-communicator
 *			- ptr to size (returned value)
 *	Returns:	- MPI_SUCCESS or error code
 */

#include <blktype.h>
#include <mpi.h>
#include <mpisys.h>

int
MPI_Comm_remote_size(comm, psize)

MPI_Comm		comm;
int			*psize;

{
	lam_initerr();
	lam_setfunc(BLKMPICOMMRSIZE);

	if (comm == MPI_COMM_NULL) {
		return(lam_errfunc(MPI_COMM_WORLD,
			BLKMPICOMMRSIZE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (LAM_IS_INTRA(comm)) {
		return(lam_errfunc(comm,
			BLKMPICOMMRSIZE, lam_mkerr(MPI_ERR_COMM, 0)));
	}

	if (psize == 0) {
		return(lam_errfunc(comm,
			BLKMPICOMMRSIZE, lam_mkerr(MPI_ERR_ARG, 0)));
	}

	*psize = comm->c_rgroup->g_nprocs;

	lam_resetfunc(BLKMPICOMMRSIZE);
	return(MPI_SUCCESS);
}
