/*
 *
 * Copyright 1998-1999, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Kinis L. Meyer with M. D. McNally 
 *          and Andrew Lumsdaine
 *
 * This file is part of the Notre Dame LAM implementation of MPI.
 *
 * You should have received a copy of the License Agreement for the
 * Notre Dame LAM implementation of MPI along with the software; see
 * the file LICENSE.  If not, contact Office of Research, University
 * of Notre Dame, Notre Dame, IN 46556.
 *
 * Permission to modify the code and to distribute modified code is
 * granted, provided the text of this NOTICE is retained, a notice that
 * the code was modified is included with the above COPYRIGHT NOTICE and
 * with the COPYRIGHT NOTICE in the LICENSE file, and that the LICENSE
 * file is distributed with the modified code.
 *
 * LICENSOR MAKES NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED.
 * By way of example, but not limitation, Licensor MAKES NO
 * REPRESENTATIONS OR WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
 * PARTICULAR PURPOSE OR THAT THE USE OF THE LICENSED SOFTWARE COMPONENTS
 * OR DOCUMENTATION WILL NOT INFRINGE ANY PATENTS, COPYRIGHTS, TRADEMARKS
 * OR OTHER RIGHTS.  
 *
 * Additional copyrights may follow.
 *
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	GDB
 *
 *	$Id: ndi_resolve.c,v 6.3 1999/07/23 03:55:27 jsquyres Exp $
 *
 *	Function:	- node identifier resolution
 */

#include <stdlib.h>

#include <all_list.h>
#include <ndi.h>
#include <net.h>
#include <portable.h>
#include <typical.h>

/*
 * local functions
 */
static int		ndi_cast();

/*
 *	ndi_resolve
 *
 *	Function:	- node identifier resolution
 *			- expands "special" node identifiers into
 *			  multiple specific node identifiers
 *	Accepts:	- node ID list
 *	Returns:	- resolved node ID list or null
 */
LIST *
ndi_resolve(nodelist)

LIST *			nodelist;

{
	struct ndi	newnode;		/* new list element */	
	struct ndi *	p;			/* current list element */
	LIST *		newnodelist;		/* resolved node ID list */
	int4		index;			/* index counter */
/*
 * Initialize the new list.
 */
	newnodelist = al_init(sizeof(struct ndi), 0);
	if (newnodelist == 0) return(0);
/*
 * Resolve each entry in the given list.
 */
	index = 0;
	p = (struct ndi *) al_top(nodelist);

	while (p) {

		if (p->ndi_node == HOST2OTB) {

			if (ndi_cast(newnodelist, 0, NT_ITB | NT_CAST,
					&index)) {
				al_free(newnodelist);
				return(0);
			}
		} else if (p->ndi_node == HOST2ALL) {

			if (ndi_cast(newnodelist, 0, NT_CAST, &index)) {
				al_free(newnodelist);
				return(0);
			}
		} else if (p->ndi_node == HOST2COMP) {

			if (ndi_cast(newnodelist, 0, NT_WASTE | NT_CAST,
					&index)) {
				al_free(newnodelist);
				return(0);
			}
		} else {
			newnode.ndi_node = p->ndi_node;
			newnode.ndi_flags = p->ndi_flags;
			newnode.ndi_count = p->ndi_count;
			newnode.ndi_index = index++;

			if (al_append(newnodelist, &newnode) == 0) {
				al_free(newnodelist);
				return(0);
			}
		}

		p = (struct ndi *) al_next(nodelist, p);
	}

	return(newnodelist);
}

/*
 *	ndi_cast
 *
 *	Function:	- expands a cast of nodes
 *	Accepts:	- node type
 *			- node mask
 *			- current index ptr
 *	Returns:	- 0 or ERROR
 */
static int
ndi_cast(nodelist, type, mask, ixp)

LIST *			nodelist;
int4			type;
int4			mask;
int			*ixp;

{
	int4		nnodes;			/* node array size */
	int4		*pnodes;		/* node array */
	int		i;
	struct ndi	newnode;		/* new list element */	

	nnodes = getntype(type, mask);
	if (nnodes < 0) return(LAMERROR);
	if (nnodes == 0) return(0);

	pnodes = (int4 *) malloc((unsigned) (nnodes * sizeof(int4)));
	if (pnodes == 0) return(LAMERROR);

	if (getnodes(pnodes, nnodes, type, mask)) {
	  free((char *) pnodes);
	  return(LAMERROR);
	}

	for (i = 0; i < nnodes; ++i) {
		newnode.ndi_node = pnodes[i];
		newnode.ndi_flags = 0;
		newnode.ndi_count = 1;
		newnode.ndi_index = (*ixp)++;

		if (al_append(nodelist, &newnode) == 0) {
		  free((char *) pnodes);
		  return(LAMERROR);
		}
	}

	free((char *) pnodes);
	return(0);
}
