dnl 
dnl Karls M4 macros for the signal system used by gtk--
dnl 
dnl  Copyright (C) 1998 Karl Nelson <kenelson@ece.ucdavis.edu>
dnl                     Tero Pulkkinen
dnl 
dnl  Currently maintained by Tero Pulkkinen. <terop@modeemi.cs.tut.fi>
dnl                                                         
dnl  This library is free software; you can redistribute it and/or
dnl  modify it under the terms of the GNU Library General Public
dnl  License as published by the Free Software Foundation; either
dnl  version 2 of the License, or (at your option) any later version.
dnl 
dnl  This library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Library General Public License for more details.
dnl 
dnl  You should have received a copy of the GNU Library General Public
dnl  License along with this library; if not, write to the Free
dnl  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl 

dnl 
dnl  Necessary M4 macros for signal implementation

dnl
dnl  M4 Quotas are hard to work with, so use braces like autoconf
dnl    (which are matched by vi, emacs)
changequote([, ])

dnl
dnl  When we want something to appear with braces 
define([BRACE],[[[$*]]])

dnl
dnl  If a macro generates an output with commas we need to protect it
dnl  from being broken down
define([PROT],[[$*]])

dnl
dnl  LOWER(string)
dnl    lowercase a string
define([LOWER],[translit([$*],[ABCDEFGHIJKLMNOPQRSTUVWXYZ],[abcdefghijklmnopqrstuvwxyz])])

dnl
dnl M4 defines $# very badly (empty list=1).  So we need a better one
define([NUM],[ifelse(len([$*]),0,0,[$#])])

dnl
dnl LIST/C_LIST(string1,cond1,string2,cond2,...)
dnl   These are intended for making extended argument lists
dnl   parameters are in pairs,  the first is output if the 
dnl   2nd is nonzero length,  the process is then repeated 
dnl   with the next set of arguments.
dnl
dnl   Macro expansions that expand to have commas must call
dnl   PROT to prevent permature expansion.  ARG* macros do
dnl   this automatically.  (If unsure, add braces until it stops
dnl   interpreting inter macros, remove one set of braces, if
dnl   still not right use PROT)
dnl 
dnl   C_LIST adds a comma in front 
define([LIST],[ifelse($#,1,,len([$2]),0,[LIST(shift(shift($@)))],len([$1]),0,[LIST(shift(shift($@)))],[[$1]C_LIST(shift(shift($@)))])])

define([C_LIST],[ifelse($#,1,,len([$2]),0,[C_LIST(shift(shift($@)))],len([$1]),0,[C_LIST(shift(shift($@)))],[,[$1]C_LIST(shift(shift($@)))])])

dnl
dnl  The following functions generate various types of parameter lists
dnl    ARG_CLASS([P1,P2]) ->  class P1,class P2
dnl    ARG_BOTH([P1,P2])  ->  P1 p1,P2 p2
dnl    ARG_TYPE([P1,P2])  ->  P1,P2
dnl    ARG_NAME([P1,P2])  ->  p1,p2
dnl
dnl  C_* - the same with a comma in front  (we should obsolete these)
dnl  _* - the actual recursive macros 
dnl    (don't call, they are subject to changes)
define([_ARG_CLASS_2],
  [ifelse(NUM($*),0,,[,class [$1][]_ARG_CLASS_2(shift($*))])])
define([_ARG_CLASS],
  [ifelse(NUM($*),0,,[class [$1][]_ARG_CLASS_2(shift($*))])])
define([_ARG_BOTH_2],
  [ifelse(NUM($*),0,,[,[$1] LOWER([$1])[]_ARG_BOTH_2(shift($*))])])
define([_ARG_BOTH],
  [ifelse(NUM($*),0,,[[$1] LOWER([$1])[]_ARG_BOTH_2(shift($*))])])
define([_ARG_TYPE],[$*])
define([_ARG_NAME],[LOWER($*)])

define([C_ARG_CLASS], [ifelse(NUM($*),0,,[,ARG_CLASS($*)])]) dnl
define([C_ARG_BOTH],[ifelse(NUM($*),0,,[,ARG_BOTH($*)])]) dnl
define([C_ARG_TYPE],[ifelse(NUM($*),0,,[,ARG_TYPE($*)])]) dnl
define([C_ARG_NAME],[ifelse(NUM($*),0,,[,ARG_NAME($*)])]) dnl

define([ARG_CLASS],[PROT(_ARG_CLASS($*))]) dnl
define([ARG_BOTH],[PROT(_ARG_BOTH($*))]) dnl
define([ARG_TYPE],[PROT(_ARG_TYPE($*))]) dnl
define([ARG_NAME],[PROT(_ARG_NAME($*))]) dnl

dnl
dnl  IF(cond,string1,string2)
dnl    places string1 if length (without spaces) of cond is zero,
dnl    else string2
define([IF],[ifelse(len(PROT(translit([$1],[ ]))),0,[$3],[$2])])
dnl define([IF],[ifelse(len(PROT(patsubst([$1],[ ]))),0,[$3],[$2])])

dnl
dnl T_DROP(string)
dnl   Removes unnecessary <> with empty templates
define([T_DROP],[ifelse([$1],<>,,[$*])])

dnl
dnl DROP(string,drop)
dnl   Removes unnecessary strings if they match drop
define([DROP],[ifelse([$1],[$2],,[$*])])

