#include <gtk--.h>
#if GTK_VERSION_GT(1,0)
// Gtk-- version of the range widgets example from the gtk+ tutorial

class OurVScale : public Gtk_VScale
{
public:
  OurVScale(const Gtk_Adjustment &gtkadjustment);
};

OurVScale::OurVScale(const Gtk_Adjustment &adjustment) :
  Gtk_VScale(adjustment)
{
  set_update_policy(GTK_UPDATE_CONTINUOUS);
  set_digits(1);
  set_value_pos(GTK_POS_TOP);
  set_draw_value(true);
}

class OurHScale : public Gtk_HScale
{
public:
  OurHScale(const Gtk_Adjustment &gtkadjustment);
};

OurHScale::OurHScale(const Gtk_Adjustment &adjustment) :
  Gtk_HScale(adjustment)
{
  set_update_policy(GTK_UPDATE_CONTINUOUS);
  set_digits(1);
  set_value_pos(GTK_POS_TOP);
  set_draw_value(true);
}

class LabeledOptionMenu : public Gtk_HBox
{
  Gtk_Label m_label;
  Gtk_ItemFactory_OptionMenu m_itemfactoryOptionMenu;

public:
  LabeledOptionMenu(const string &menutitle, const string &factoryroot,
		    bool homogeneous=false,
		    gint spacing=10);
  void finalize();

  // factory accessor : better than delegating a template method
  Gtk_ItemFactory_OptionMenu* factory() {return &m_itemfactoryOptionMenu;} 
  
};

LabeledOptionMenu::LabeledOptionMenu(const string &menutitle,
				     const string &factoryroot,
				     bool homogeneous,
				     gint spacing) :
  Gtk_HBox(homogeneous, spacing),
  m_label(menutitle),
  m_itemfactoryOptionMenu(factoryroot)
{
  set_border_width(10);
  pack_start(m_label, false, false, 0);
  // we can't pack the itemfactory at this point : no items could
  // possibly have been created. So this is done in the realize_impl() 
  //connect_to_method(realize, this, &finalize);
}

void LabeledOptionMenu::finalize()
{
  // FIX THIS
  //  pack_start(m_itemfactoryOptionMenu.get_optionmenu_widget("").get());
}


class LabeledScale : public Gtk_HBox
{
  Gtk_Label m_label;
  Gtk_Adjustment m_adj;
  Gtk_HScale m_hscale;
  
public:
  LabeledScale(const string &title,
	       // adjustment args
	       gfloat value, gfloat lower, gfloat upper,
	       gfloat step_increment=1, gfloat page_increment=10,
	       gfloat page_size=0,
	       // box args
	       bool homogeneous=false,
	       gint spacing=10);
};

LabeledScale::LabeledScale(const string &title,
			   gfloat value, gfloat lower, gfloat upper,
			   gfloat step_increment, gfloat page_increment,
			   gfloat page_size,
			   bool homogeneous,
			   gint spacing) :
  Gtk_HBox(homogeneous, spacing),
  m_label(title),
  m_adj(value, lower, upper, step_increment, page_increment, page_size),
  m_hscale(m_adj)
{
  pack_start(m_label, false, false, 0);

  //  connect_to_method();
  m_hscale.set_digits(0);
  pack_start(m_hscale);
};


class RangeControls : public Gtk_Window
{

  Gtk_VBox m_vbox1, m_vbox2, m_vbox3;
  Gtk_HBox m_hbox1, m_hbox2;

  Gtk_Adjustment m_adj1;

  OurVScale m_vscale;
  OurHScale m_hscale;

  Gtk_HSeparator m_seperator;
  
  Gtk_Button m_buttonQuit;
  Gtk_CheckButton m_checkbutton;
  
  Gtk_HScrollbar m_scrollbar;

  LabeledOptionMenu m_optmenu1, m_optmenu2;
  
  LabeledScale m_lscale1, m_lscale2;
  
public:

  RangeControls();

  // callbacks
  void draw_value(Gtk_CheckButton *button);
  void menu_pos_select_cb(GtkPositionType type);
  void menu_update_select_cb(GtkUpdateType type);
  
  gint delete_event_impl(GdkEventAny*) { 
    Gtk_Main::instance()->quit(); return 0; 
  }

};

RangeControls::RangeControls() :
  m_vbox1(false, 0),
  m_vbox2(false, 10),
  m_vbox3(false, 10),

  m_hbox1(false, 10),
  m_hbox2(false, 10),

  // value, lower, upper, step_increment, page_increment, page_size
  // note that the page_size value only makes a difference for
  // scrollbar widgets, and the highest value you'll get is actually
  // (upper - page_size).
  m_adj1(0.0, 0.0, 101.0, 0.1, 1.0, 1.0),

  m_vscale(m_adj1),

  m_hscale(m_adj1),

  m_buttonQuit("Quit"),
  // a checkbutton to control whether the value is displayed or not
  m_checkbutton("Display value on scale widgets"),

  // reuse the same adjustment again
  m_scrollbar(m_adj1),
  // notice how this causes the scales to always be update
  // continuously when the scrollbar is moved

  // an option menu to change the position of the value
  m_optmenu1("Scale Value Position:", "<ScaleValuePosition>"),
  m_optmenu2("Scale Update Policy:", "<ScaleUpdatePolicy>"),

  // a GtkHScale widget for adjusting the number of digits on the
  // sample scales.
  m_lscale1("Scale Digits:",
	    1.0, 0.0, 5.0, 1.0, 1.0, 0.0),
  // And, one last GtkHScale widget for adjusting the page size of the
  // scrollbar.
  m_lscale2("Scrollbar Page Size:",
	    1.0, 1.0, 101.0, 1.0, 1.0, 0.0)
{
  set_title("range controls");
  add(&m_vbox1);
  m_vbox1.pack_start(m_hbox1);
  
  m_hbox1.pack_start(m_vscale);
  
  m_hbox1.pack_start(m_vbox2);
  
  m_hscale.set_usize(200, 30);
  m_vbox2.pack_start(m_hscale);
  
  m_scrollbar.set_update_policy(GTK_UPDATE_CONTINUOUS);
  m_vbox2.pack_start(m_scrollbar);
  
  m_hbox2.set_border_width(10);
  m_vbox1.pack_start(m_hbox2);
  
  m_checkbutton.set_active(true);
  connect_to_method(m_checkbutton.toggled, this, &draw_value, &m_checkbutton);
  m_hbox2.pack_start(m_checkbutton);
  
//   Gtk_ItemFactory *factory;
  Gtk_ItemFactory_OptionMenu *factory =
    new Gtk_ItemFactory_OptionMenu("<Main>");
  
  // Scale Value Position
//   factory = m_optmenu1.factory();

  cout << "Create item 'Top' " << endl;

  // FIX THIS
//   Gtk_OptionMenu *optm = (Gtk_OptionMenu*)(factory->create_item("/Scale Value Position",
// 								"", "<Title>", 0));

  factory->create_item("/Top", "", "<ToggleItem>",
		       this, &menu_pos_select_cb, GTK_POS_TOP);
//   cout << "Create item 'Bottom' " << endl;
//   factory->create_item("/ScaleValuePosition/Bottom", 0, "<ToggleItem>",
// 		       this, &menu_pos_select_cb, GTK_POS_BOTTOM);
//   cout << "Create item 'Left' " << endl;
//   factory->create_item("/ScaleValuePosition/Left", 0, "<ToggleItem>",
// 		       this, &menu_pos_select_cb, GTK_POS_LEFT);
//   cout << "Create item 'Right' " << endl;
//   factory->create_item("/ScaleValuePosition/Right", 0, "<ToggleItem>",
// 		       this, &menu_pos_select_cb, GTK_POS_RIGHT);
//   m_optmenu1.pack_start(factory->get_optionmenu_widget("<ScaleValuePosition>"));
  cout << "Creation finished - packing widget in vbox" << endl;
  
  // FIX THIS
  // m_vbox1.pack_start(optm);
  
  //  m_vbox1.pack_start(m_optmenu1);

#if 0
  // Scale Update Policy
  factory = m_optmenu2.factory();

  cout << "Create item 'Continuous' " << endl;
  factory->create_item("/Scale Update Policy", "", "<Branch>", 0);

  factory->create_item("/Scale Update Policy/Continuous/", "", "<ToggleItem>",
		       this, &menu_update_select_cb, GTK_UPDATE_CONTINUOUS);
  cout << "Create item 'Discontinuous' " << endl;
  factory->create_item("/Scale Update Policy/Discontinuous/", "", "<ToggleItem>",
		       this, &menu_update_select_cb, GTK_UPDATE_DISCONTINUOUS);  cout << "Create item 'Delayed' " << endl;
  factory->create_item("/Scale Update Policy/Delayed/", "", "<ToggleItem>",
		       this, &menu_update_select_cb, GTK_UPDATE_DELAYED);
  m_optmenu2.pack_start(factory->get_optionmenu_widget(""));
  m_vbox1.pack_start(m_optmenu2);
#endif

  m_vbox1.pack_start(m_lscale1);
  m_vbox1.pack_start(m_lscale2);
  m_vbox1.pack_start(m_seperator, false, true, 0);
  
  m_vbox3.pack_start(m_buttonQuit);
  m_buttonQuit.set_flags(GTK_CAN_DEFAULT);
  m_buttonQuit.grab_default();
  connect_to_method(m_buttonQuit.clicked, Gtk_Main::instance(),
		    &Gtk_Main::quit);
  
  m_vbox1.pack_start(m_vbox3);
  
  show_all();

}

void RangeControls::draw_value(Gtk_CheckButton *button)
{}

void RangeControls::menu_pos_select_cb(GtkPositionType postype)
{}

void RangeControls::menu_update_select_cb(GtkUpdateType type)
{}



int main(int argc, char *argv[])
{
  cerr << "NOT WORKING YET - SORRY" << endl;
  return -1;
  
  Gtk_Main myapp(&argc, &argv);
  RangeControls rangecontrols;

  myapp.run();
  return 0;
}

#else
int main(int argc, char *argv[])
{
  cerr << "Only works with Gtk+ 1.1 or greater."<<endl;
}
#endif

