#include <iostream>
#include <gtk--.h>

// Gtk-- version of the "pixmap" example from the gtk+ tutorial

/* XPM data of Open-File icon */
static const char * xpm_data[] = {
  "16 16 3 1",
  "       c None",
  ".      c #000000000000",
  "X      c #FFFFFFFFFFFF",
  "                ",
  "   ......       ",
  "   .XXX.X.      ",
  "   .XXX.XX.     ",
  "   .XXX.XXX.    ",
  "   .XXX.....    ",
  "   .XXXXXXX.    ",
  "   .XXXXXXX.    ",
  "   .XXXXXXX.    ",
  "   .XXXXXXX.    ",
  "   .XXXXXXX.    ",
  "   .XXXXXXX.    ",
  "   .XXXXXXX.    ",
  "   .........    ",
  "                ",
  "                "
};

class Pixmap : public Gtk_Window
{
  Gtk_Button m_button;
  Gtk_Pixmap m_pixmap;

  gint delete_event_impl(GdkEventAny*) { 
    Gtk_Main::instance()->quit(); return 0; 
  }

public:
  Pixmap();
  void button_clicked() { cout << "button clicked" << endl; }

};

Pixmap::Pixmap() :
  m_pixmap(*this, xpm_data)
{
  add(&m_button);
  m_button.add(&m_pixmap);

  connect_to_method(m_button.clicked, this, &button_clicked);
  
  show_all();
}


int main (int argc, char *argv[])
{
          
  Gtk_Main myapp(&argc, &argv);

  Pixmap pixmap;

  myapp.run();
  return 0;
}
