#include <iostream>
#include <string>
#include <gtk--.h>

// Gtk-- version of the "buttons" example from the gtk+ tutorial

class XPMLabelBox : public Gtk_HBox
{
public:
  Gtk_Label m_label;
  Gtk_Pixmap m_pixmap;
  
  XPMLabelBox(Gtk_Widget &parent, const string &xpm_filename,
	      const string &label_text);
};

XPMLabelBox::XPMLabelBox(Gtk_Widget &parent, const string &xpm_filename,
			 const string &label_text) :
  Gtk_HBox(false, 0),
  m_label(label_text),
  m_pixmap(parent, xpm_filename) // the Gtk_Pixmap constructor will get the parent's style
{
  set_border_width(2);
  
  pack_start(m_pixmap, false, false, 3);
  pack_start(m_label, false, false, 3);
  
  m_pixmap.show();
  m_label.show();
}

class Buttons : public Gtk_Window
{
public:
  Gtk_Button m_button;
  XPMLabelBox m_box1;

  Buttons();

  void callback(char *data) 
    {
      cout << "Hello again - " << data << " was pressed" << endl;
    }

  gint delete_event_impl(GdkEventAny*) { 
    Gtk_Main::instance()->quit(); return 0; 
  }
  
};

Buttons::Buttons() :
  m_box1(m_button, "info.xpm", "cool button")
{
  set_title("Pixmap'd buttons!");
  set_border_width(10);
  
  connect_to_method(m_button.clicked, this, &callback, "cool button");
  
  m_button.add(&m_box1);
  add(&m_button);
  show_all();
}

int main (int argc, char *argv[])
{
  Gtk_Main myapp(&argc, &argv);

  Buttons buttons;

  myapp.run();
  return 0;
}
