/* example-start clist clist.cc */

#include <gtk--.h>

class Wnd: public Gtk_Window
{
    Gtk_VBox vbox;
    Gtk_HBox hbox;
    Gtk_CList clist;
    Gtk_Button button_add, button_clear, button_hide_show;
    bool titles_show;
public:
    Wnd();
private:
    gint delete_event_impl(GdkEventAny*) { 
        Gtk_Main::instance()->quit(); return 0; 
    }
    void fill_list();
    void hide_show();
    void selected(int row, int col, GdkEvent* e);
};

Wnd::Wnd():
    Gtk_Window(GTK_WINDOW_TOPLEVEL),
    vbox(false, 5),
    hbox(false, 0),
    clist(2), // 2 is the number of columns
    button_add("Add List"),
    button_clear("Clear List"),
    button_hide_show("Hide/Show titles"),
    titles_show(true)
{
    set_title("Gtk_CList Example");
    set_usize(300, 150);

    clist.set_column_title(0, "Ingredients");
    clist.set_column_title(1, "Amount");
    clist.column_titles_show();
    /* It is important to set the column widths as they will never be
     * right othervise. Note that the columns are numbered from 0 and
     * up (to 1 in this case). */
    clist.set_column_width(0, 150);
    /* It isn't necessary to shadow the border, but it looks nice :) */
    clist.set_shadow_type(GTK_SHADOW_OUT);
    /* This is where we actually get the selection */
    connect_to_method(clist.select_row, this, &selected);

    /* Connect the buttons and add them to the window. See the button
     * tutorial for more examples and comments on this.
     */
    
    connect_to_method(button_add.clicked, this, &fill_list);
    connect_to_signal(button_clear.clicked, clist.clear);
    connect_to_method(button_hide_show.clicked, this, &hide_show);
    
    hbox.pack_start(button_add, true, true, 0);
    hbox.pack_start(button_clear, true, true, 0);
    hbox.pack_start(button_hide_show, true, true, 0);
    
    vbox.pack_start(clist, true, true, 0);
    vbox.pack_start(hbox, false, true, 0);
    vbox.set_border_width(5);
    add(vbox);
    vbox.show_all();
}

void Wnd::fill_list()
{
    /* Something silly to add to the list. 4 rows of 2 columns each */
     const gchar *drink[4][2] = { { "Milk",    "3 Oz" },
                           { "Water",   "6 l" },
                           { "Carrots", "2" },
                           { "Snakes",  "55" } };
    /* Here we do the actual adding of the text. It's done once for
     * each row.
     */
    for (int indx=0 ; indx < 4 ; indx++ )
	clist.append(&drink[indx][0]);
}

void Wnd::hide_show()
{
    titles_show = !titles_show;
    if (titles_show)
	clist.column_titles_show();
    else
	clist.column_titles_hide();
}

void Wnd::selected(int row, int col, GdkEvent* e)
{
    cout << "You selected row " << row << ". ";
    cout << "More specifically you clicked in column " << col;
    _gtk_string selected_word;
    if (clist.get_text(row, col, &selected_word))
	cout << " and the text in this cell is " << selected_word;
    cout << endl << endl;
    
}

int main(int argc, char *argv[])
{
    Gtk_Main m(&argc, &argv);
    Wnd window;

    window.show();
    m.run();
    
    return(0);
}
/* example-end */
