#include "FileSelectionTest.h"

FileSelectionTest * FileSelectionTest::theTest = 0;

TestFixture * 
FileSelectionTest::create ()
{
  if ( theTest == 0 ) 
    {
      theTest = new FileSelectionTest ();
      return theTest;
    }
  return 0;
}

void
FileSelectionTest::hide_fileops () 
{
  fileSelection . hide_fileop_buttons ();
}

void
FileSelectionTest::show_fileops () 
{
  fileSelection . show_fileop_buttons ();
}

void
FileSelectionTest::ok ()
{
  cout << fileSelection . get_filename () << endl;
  finished ( this );
}


FileSelectionTest::FileSelectionTest () :
  fileSelection ( "file selection dialog" )
{
  Gtk_Button * button;

  fileSelection . hide_fileop_buttons ();

  set_position ( GTK_WIN_POS_MOUSE );

  connect_to_method ( fileSelection . get_ok_button () -> clicked, this, &FileSelectionTest::ok );
  connect_to_signal ( fileSelection . get_cancel_button () -> clicked, finished, this );
      
  button = new Gtk_Button ( "Hide Fileops" );
  connect_to_method ( button -> clicked, this, &FileSelectionTest::hide_fileops );
  fileSelection . get_action_area () -> pack_start ( manage ( button ), false, false, 0 );
  button -> show ();
  
  button = new Gtk_Button ( "Show Fileops" );
  connect_to_method ( button -> clicked, this, &FileSelectionTest::show_fileops );
  fileSelection . get_action_area () -> pack_start ( manage ( button ), false, false, 0 );
  button -> show ();
  fileSelection . show ();
}

