------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUN-TIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--           S Y S T E M . I N T E R R U P T _ M A N A G E M E N T          --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.5 $                             --
--                                                                          --
--           Copyright (C) 1991-1998, Florida State University              --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This is a OpenVMS/Alpha version of this package.

--  PLEASE DO NOT add any dependences on other packages.
--  This package is designed to work with or without tasking support.

--  See the other warnings in the package specification before making
--  any modifications to this file.

with System.OS_Interface;
--  used for various Constants, Signal and types

package body System.Interrupt_Management is

   use System.OS_Interface;

   type Interrupt_List is array (Interrupt_ID range <>) of Interrupt_ID;

   ---------------------------
   -- Initialize_Interrupts --
   ---------------------------

   --  Nothing needs to be done on this platform.

   procedure Initialize_Interrupts is
   begin
      null;
   end Initialize_Interrupts;

begin
   --  Unused
   Abort_Task_Interrupt := Event_Flag_0;

   Reserve := Reserve or Keep_Unmasked or Keep_Masked;

   --  VMS uses some of these.
   Reserve (Event_Flag_0) := True;
   Reserve (Event_Flag_1) := True;
   Reserve (Event_Flag_2) := True;
   Reserve (Event_Flag_3) := True;
   Reserve (Event_Flag_4) := True;
   Reserve (Event_Flag_5) := True;
   Reserve (Event_Flag_6) := True;
   Reserve (Event_Flag_7) := True;
   Reserve (Event_Flag_8) := True;
   Reserve (Event_Flag_9) := True;
   Reserve (Event_Flag_10) := True;
   Reserve (Event_Flag_11) := True;
   Reserve (Event_Flag_12) := True;
   Reserve (Event_Flag_13) := True;
   Reserve (Event_Flag_14) := True;
   Reserve (Event_Flag_15) := True;
   Reserve (Event_Flag_16) := True;
   Reserve (Event_Flag_17) := True;
   Reserve (Event_Flag_18) := True;
   Reserve (Event_Flag_19) := True;
   Reserve (Event_Flag_20) := True;
   Reserve (Event_Flag_21) := True;
   Reserve (Event_Flag_22) := True;
   Reserve (Event_Flag_23) := True;
   Reserve (Event_Flag_24) := True;
   Reserve (Event_Flag_25) := True;
   Reserve (Event_Flag_26) := True;
   Reserve (Event_Flag_27) := True;
   Reserve (Event_Flag_28) := True;
   Reserve (Event_Flag_29) := True;
   Reserve (Event_Flag_30) := True;
   Reserve (Event_Flag_31) := True;
end System.Interrupt_Management;
