/*
This file is licensed to you under the license specified in the included file
`LICENSE'. Look there for further details.
*/


%{
#include "argsdef.h"
extern int gengetopt_count_line;
extern int gengetopt_add_option (char * long_opt, char short_opt, char * desc, int type, int flagstat_or_required);
static int gengetopt_package_given = 0;
static int gengetopt_version_given = 0;
#define YYERROR_VERBOSE 1
#define check_result \
	if (o) { switch (o) { case 1: yyerror ("not enough memory"); break; case 2: yyerror ("long option redefined"); break; case 3: yyerror ("short option redefined"); break; case 4: yyerror ("bug found!!"); break; } YYERROR; }
%}

%union {
char * str;
char chr;
int argtype;
int bool;
}

%token           TOK_PACKAGE
%token           TOK_VERSION
%token           TOK_OPTION
%token           TOK_YES
%token           TOK_NO
%token           TOK_FLAG
%token <bool>    TOK_ONOFF
%token <str>     TOK_STRING
%token <str>     TOK_STRING_WITH_SPACES
%token <chr>     TOK_CHAR
%token <argtype> TOK_ARGTYPE
%type  <str>     exp_str
%type  <bool>    exp_yesno


%%


input:	/* empty */
	| input line
;


line:	'\n'
	| exp '\n'
;


exp_str:	  TOK_STRING_WITH_SPACES { $$ = $1; }
		| TOK_STRING             { $$ = $1; }
;


exp_yesno:	  TOK_YES  { $$ = 1; }
		| TOK_NO   { $$ = 0; }
;


exp: TOK_PACKAGE TOK_STRING { if (gengetopt_package_given) { yyerror ("package redefined"); YYERROR; } else { gengetopt_package_given = 1; if (gengetopt_define_package ($2)) { yyerror ("not enough memory"); YYERROR; } } }
;


exp: TOK_VERSION TOK_STRING { if (gengetopt_version_given) { yyerror ("version redefined"); YYERROR; } else { gengetopt_version_given = 1; if (gengetopt_define_version ($2)) { yyerror ("not enough memory"); YYERROR; } } }
;


exp: TOK_OPTION TOK_STRING TOK_CHAR exp_str TOK_NO { int o = gengetopt_add_option ($2, $3, $4, ARG_NO, 0); check_result; }
;


exp: TOK_OPTION TOK_STRING TOK_CHAR exp_str TOK_FLAG TOK_ONOFF { int o = gengetopt_add_option ($2, $3, $4, ARG_FLAG, $6); check_result; }
;

     
exp: TOK_OPTION TOK_STRING TOK_CHAR exp_str TOK_ARGTYPE exp_yesno { int o = gengetopt_add_option ($2, $3, $4, $5, $6); check_result; }
;


%%


