.TH FTNPP 1L "17 October 1999"
.SH NAME
ftnpp \- Fortran preprocessor
.SH SYNOPSIS
\fBftnpp\fP
[\fB\-C\fP]
[\fB\-P\fP]
[\fB\-I\fP \fIdirectory\fP]
[\fIinfile\fP
[\fIoutfile\fP]]

.SH DESCRIPTION
\fBftnpp\fP provides a preprocessor for Fortran source files.
Actually, it is just a front-end for \fBcpp\fP(1) or \fBfpp\fP(1), adding the
capability of including Fortran-style \fCINCLUDE\fR files as well as
C-style \fC#include\fR files.  It processes \fIinfile\fP or standard
input and passes the expanded source to \fBcpp\fP for substitution of
macros and other types of preprocessing.  The result is sent to
\fIoutfile\fP or standard output.
.PP
\fBftnpp\fP passes \fIoutfile\fP and all of its options to \fBcpp\fP.
If some options should not be passed to \fBcpp\fP, use \fB\-\-\fP
followed by any options that should not be passed along.
.PP
The intended purpose of \fBftnpp\fP is to serve as a
preprocessor for \fBftnchek\fP(1).

.SH OPTIONS
.TP
\fB\-C\fP
Retain Fortran-77 style comments (lines beginning with C, c, or *).
By default, comment lines are replaced by blank lines.
Inline comments (introduced by !) are always retained since
\fBftnpp\fP does not do enough lexical analysis of the file to identify them.
When passed to \fBcpp\fP, this option implies also retain C-style comments.
.TP
\fB\-P\fP
Suppress the printing of `\|\fB#\fP\|'-line directives with
line-number information.
.TP
\fB\-I\fP \fIdirectory\fP
Search directory \fIdirectory\fP for include-files.
Unlike \fBcpp\fP, \fBftnpp\fP only searches the directory containing
the source file by default.
.PP
Any options not in the above list are passed along to \fBcpp\fP.
Options that take a parameter, namely \fB\-D\fP and \fB\-U\fP,
can be either attached to or separated from their parameter.

.SH SEE ALSO
.BR cpp (1),
.BR fpp (1),
.BR ftnchek (1).

.SH AUTHOR
Robert Moniot <moniot@fordham.edu>

.SH BUGS
Under Digital Unix, the line-number information locating include-files
is off by one.  This appears to be a problem with DU \fBcpp\fP.
