-- Copyright 1998 Richie Bielak and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Global function for GTK apps, including event loop"
	version: "v 0.3.3 GTK+ 1.2.x"
	author: "Richie Bielak"
	cvs: "$Id: gtk_application.e,v 1.6 1999/10/03 02:07:18 richieb Exp $"

class GTK_APPLICATION

-- Top-level class that must be included in every program that uses this
-- library.
--
-- You must call initialize_tool_kit before any other GTK features.
-- Use wait_for_events to start the main event loop.

inherit

	GTK_APPLICATION_EXTERNALS

	GTK_MAIN_EXTERNALS
 
	GTK_RC_EXTERNALS

	EGTK_NON_PORTABLE

feature

	set_locale is
		do
			gtk_set_locale 
		end

	parse_rc_file (fname: STRING) is
		require
			fname /= Void 
		do
			-- gtk_rc_parse ($(fname.to_c))
			npc.np_gtk_rc_parse (fname)
		end
			   

	initialize_tool_kit is
			-- this must be called first before GTK can be used
		do
			c_gtk_init_tool_kit
		end

	wait_for_events is
		do
			gtk_main
		end

	quit_application is
		do
			gtk_main_quit
		end

	exit (n: INTEGER) is
		do
			gtk_exit (n)
		end

end
