indexing
	description: "C type definition"
	status: "See notice at end of class"
	author: "Sam O'Connor"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class
	C_TYPEDEF

creation
	
	make

feature -- Initilization

	make (new_name: STRING; new_indir: INTEGER; new_base: STRING) is
		require
			new_name_valid: new_name /= Void
			new_indir_valid: new_indir >= 0
			new_base_valid: new_base /= Void
		do
			name := clone (new_name)
			indir := new_indir
			base := clone (new_base)
		ensure
			name_set: name = new_name or else name.is_equal (new_name)
			indir_set: indir = new_indir
			base_set: base = new_base or else base.is_equal (new_base)
		end

feature -- Access

	name: STRING

	indir: INTEGER
	
	base: STRING

	set_base (new_base: STRING) is
		require
			new_base_valid: new_base /= Void
		do
			base := clone (new_base)
		ensure
			base_set: base.is_equal (new_base)
		end

	set_indir (new_indir: INTEGER) is
		require
			new_indir_valid: new_indir >= 0
		do
			indir := new_indir
		ensure
			indir_set: indir = new_indir
		end

	add_indir (new_indir: INTEGER) is
		require
			new_indir_valid: new_indir >= 0
		do
			indir := indir + new_indir
		ensure
			indir_added: indir = new_indir + old indir
		end

invariant

	valid_name: name /= Void
	valid_indir: indir >= 0
	valid_base: base /= Void

end -- class C_TYPEDEF


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
