%{

indexing
	description: "Scan C header file for structs "
	author: "Sam O'Connor"
	status: "see notice at end of class"
	date: "$Date: 1999/11/19 21:21:30 $"
	revision: "$Revision: 1.2 $"

class
	C_STRUCT_SCANNER

inherit
	YY_COMPRESSED_SCANNER_SKELETON

	C_STRUCT_TOKENS

creation
	make_with_file

%}

WS    [ \r\f\v\t\n]
ID    [_A-Za-z][_A-Za-z0-9]*

%x SC_FILE
%x SC_STRUCT
%x SC_STRUCT_MEM
%x SC_BRACE
%x SC_STRUCT_TD

%%

^#.*                   { set_start_condition (SC_FILE)
                         less (0)                                           }
<SC_FILE>#{WS}+[0-9]+{WS}+\" -- chew leading junk
<SC_FILE>\"{WS}.*\n    { set_start_condition (INITIAL)
                         unread_character (';')                             }
<SC_FILE>[^"\n]+       { file_name := clone (text)
                         -- This looks dumb, but as far as I can tell
                         -- STRING.last_index_of is broken :(
                         file_name.mirror
                         file_name := file_name.substring (1, (file_name.index_of('/',1)-1))
                         file_name.mirror
                         last_token := TOK_FILE
                         create last_value.cs (file_name)                   }

";"{WS}+struct{WS}+{ID}";" { unread_character (';')                         } 
";"{WS}+struct        { set_start_condition (SC_STRUCT)
                        last_token := TOK_STRUCT                            }
typedef{WS}+struct    { set_start_condition (SC_STRUCT_TD)
                        last_token := TOK_STRUCT_TD                         }
.|\n 

<SC_STRUCT>{ID}       { last_token := TOK_ID    create last_value.cs (text) }
<SC_STRUCT>"{"        { set_start_condition (SC_STRUCT_MEM)
                        last_token := TOK_LB                                }
<SC_STRUCT>";"        { set_start_condition (INITIAL)
                        unread_character (';')
                        last_token := TOK_SC                                }
<SC_STRUCT>.|\n      -- chew leftovers

<SC_STRUCT_MEM>struct -- chew sub structs/unions for now
<SC_STRUCT_MEM>union
<SC_STRUCT_MEM>{ID}   { last_token := TOK_ID    create last_value.cs (text) }
<SC_STRUCT_MEM>\*+    { last_token := TOK_INDIR create last_value.cs (text) }
<SC_STRUCT_MEM>";"    { last_token := TOK_SC                                }
<SC_STRUCT_MEM>"{"    { set_start_condition (SC_BRACE)
                        brace_depth := 1                                    }
<SC_STRUCT_MEM>"}"    { set_start_condition (SC_STRUCT)
                        last_token := TOK_RB                                }
<SC_STRUCT_MEM>.|\n  -- Chew leftovers

<SC_BRACE>"{"         { brace_depth := brace_depth + 1                      }
<SC_BRACE>"}".*";"    { brace_depth := brace_depth - 1
                        if brace_depth = 0 then
                            set_start_condition (SC_STRUCT_MEM)
                        end                                                 } 
<SC_BRACE>.|\n       -- Chew leftovers

<SC_STRUCT_TD>{ID}    { last_token := TOK_ID     create last_value.cs(text) }
<SC_STRUCT_TD>\*+     { last_token := TOK_INDIR  create last_value.cs(text) }
<SC_STRUCT_TD>";"     { set_start_condition (INITIAL)
                        unread_character (';')
                        last_token := TOK_SC                                }
<SC_STRUCT_TD>.|\n   -- Chew leftovers

%%

	file_name: STRING
	brace_depth: INTEGER
	last_value: C_STRUCT_PARSER_UNION

end


--!-----------------------------------------------------------------------------
--! The GOTE converter. It converts GTK+ Objects To Eiffel.
--! Copyright (C) 1999 Sam O'Connor
--!
--! This program is free software; you can redistribute it and/or modify
--! it under the terms of the GNU General Public License as published by
--! the Free Software Foundation; either version 2 of the License, or
--! (at your option) any later version.
--!
--! This program is distributed in the hope that it will be useful,
--! but WITHOUT ANY WARRANTY; without even the implied warranty of
--! MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--! GNU General Public License for more details.
--!
--! You should have received a copy of the GNU General Public License
--! along with this program; if not, write to the Free Software
--! Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--!
--! See file "licence" for more information.
--!-----------------------------------------------------------------------------
