-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkAlignment objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"

class GTK_ALIGNMENT_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_ALIGNMENT"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			xalign := widget_tree.get_real_string_from_field("xalign")
			yalign := widget_tree.get_real_string_from_field("yalign")
			xscale := widget_tree.get_real_string_from_field("xscale")
			yscale := widget_tree.get_real_string_from_field("yscale")
			create_child_class(widget_tree.find_child("widget"))
		end
			
	xalign: STRING
	yalign: STRING
	xscale: STRING
	yscale: STRING

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make("+xalign+", "+yalign+", "+
						xscale+", "+yscale+")")
			add_widget_code(code)
			precursor(code)
		end

end
