
(*Toplevel loop for the communication between Coq and Centaur *)
open Names;;
open Std;;
open More_util;;
open Generic;;
open Ast;;
open Term;;
open Pp;;
open Termenv;;
open Libobject;;
open Library;;
open Vernacinterp;;
open Trad;;
open Evd;;
open Proof_trees;;
open Termast;;
open Tacmach;;
open Pfedit;;
open Parsing;;
(* open Refiner;; *)
open Vectops;;
open Constrtypes;;
open Environ;;
open Machops;;
open Coqtoplevel;;
open Reduction;;
open Classops;;
open Vernacinterp;;
open Vernac;;
open CoqAst;;
open Protectedtoplevel;;
open Line_oriented_parser;;
open Xlate;;
open Vtp;;
open Ascent;;
open Translate;;
open Name_to_ast;;
(* open Ntcentaur;; *)


set_flags := (function () ->
                if List.mem "G_natsyntax" (Mltop.get_loaded_modules()) then
                  (g_nat_syntax_flag := true; ())
                else ());;

let guarded_force_eval_stream s = 
  let l = ref [] in
  let f elt = l:= elt :: !l in 
  (try  Stream.iter f s with
  | _ -> f (sTR "error guarded_force_eval_stream"));
  Stream.of_list (List.rev !l);;


let rec reverse_and_expand l = function
    [] -> l
  | p::tl -> if p < 0 then
            let rec rev_aux l n =
                if n = 0 then
                   l
                else
                   rev_aux (1::l) (n - 1) in
               reverse_and_expand (rev_aux l (-p)) tl 
            else
               reverse_and_expand (p::l) tl;;
               
let solve_proof_command path tcom =
 traverse_to (reverse_and_expand [] path); by (Tacinterp.vernac_interp tcom);;

let kill_proof_node path =
 traverse_to (reverse_and_expand [] path);
       Pfedit.mutate weak_undo_pftreestate;;

(*A global request_id so that we can know to whom the ctf_StateMessage and
  Newctf_StateMessage, ctf_SearchResults, are destined in a multiple-paned world.
  The reason our first attempt will be done this way, is currently the 
  command sent from centaur and its acknowledgement (or error msg) contain
  a request id.  However, the Vernac.parse_vernac function which we use
  to override the interpreter entries, doesn't allow us to be closer than
  this currently.  This global request id is provided by Protectedtoplevel *)

(*Message functions, the text of these messages is recognized by the protocols *)
(*of CtCoq                                                                     *)
let acknowledge_command request_id =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "acknowledge"; 'fNL; 'iNT request_id; 'fNL;
 'sTR "***"; 'fNL >];;

let ctf_SearchResults request_id =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "search_results"; 'fNL; 'iNT request_id; 'fNL;
 'sTR "***"; 'fNL >];;

let ctf_StateMessage request_id =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "state"; 'fNL; 'iNT request_id; 'fNL; 'sTR "***";
 'fNL >];;

let ctf_PathGoalMessage () =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "single_goal"; 'fNL >];;

let ctf_PathGoalReqIdMessage request_id =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "single_goal_state"; 
'fNL; 'iNT request_id; 'fNL; 'sTR "***"; 'fNL  >];;

let ctf_NewStateMessage request_id =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "fresh_state"; 'fNL; 'iNT request_id; 'fNL;
 'sTR "***"; 'fNL >];;

let ctf_SavedMessage () = [< 'fNL; 'sTR "message"; 'fNL; 'sTR "saved"; 'fNL >];;

let ctf_KilledMessage request_id =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "killed"; 
    'fNL; 'iNT request_id; 'fNL; 'sTR "***"; 
    'fNL >];;

let ctf_AbortedAllMessage () =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "aborted_all"; 'fNL >];;

let ctf_AbortedMessage request_id na =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "aborted_proof"; 'fNL; 'iNT request_id; 'fNL;
 'sTR "***"; 'fNL; 'sTR na; 'fNL; 'sTR "E-n-d---M-e-s-s-a-g-e"; 'fNL >];;

let ctf_UserErrorMessage request_id stream =
 let stream = guarded_force_eval_stream stream in
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "user_error"; 'fNL; 'iNT request_id; 'fNL;
 'sTR "***"; 'fNL; stream; 'fNL; 'sTR "E-n-d---M-e-s-s-a-g-e"; 'fNL >];;

let ctf_ResetInitialMessage () =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "reset_initial"; 'fNL >];;

let ctf_ResetIdentMessage request_id str =
 [< 'fNL; 'sTR "message"; 'fNL; 'sTR "reset_ident"; 'fNL; 'iNT request_id; 'fNL;
 'sTR "***"; 'fNL; 'sTR str; 'fNL; 'sTR "E-n-d---M-e-s-s-a-g-e"; 'fNL >];;

type vtp_tree =
  | P_rl of ct_RULE_LIST
  | P_s of ct_STATE
  | P_r of ct_RULE
  | P_s_int of ct_SIGNED_INT_LIST
  | P_pl of ct_PREMISES_LIST
  | P_cl of ct_COMMAND_LIST
  | P_t of ct_TACTIC_COM;;

let print_tree t = 
  (match t with
  | P_rl x -> fRULE_LIST x
  | P_s x -> fSTATE x
  | P_r x -> fRULE x
  | P_s_int x -> fSIGNED_INT_LIST x
  | P_pl x -> fPREMISES_LIST x
  | P_cl x -> fCOMMAND_LIST x
  | P_t x -> fTACTIC_COM x);
  print_string "e\nblabla\n";;



let centaur_explain_exn  f e =
 ctf_UserErrorMessage !global_request_id (f e);;

let output_results stream vtp_tree =
    let _ = Sys.signal Sys.sigint
       (Sys.Signal_handle(fun i -> (break_happened := true;()))) in
    mSG stream;
    match vtp_tree with
      Some t -> print_tree t
    | None -> ();;

(*This code is used to display the current list of goals *)
let print_centaur_new_state () =
 let pfs = get_pftreestate () in
 let pf = proof_of_pftreestate pfs in
 output_results
  (ctf_NewStateMessage !global_request_id)
  (Some(P_rl (translate_node_state [] pf)));;

let print_centaur_all_state () =
 traverse_to [];
 let pfs = get_pftreestate () in
 let pf = proof_of_pftreestate pfs in
 output_results
  (ctf_NewStateMessage !global_request_id) 
  (Some (P_rl (translate_all_goals [] pf)));;

let print_centaur_state () =
 let pfs = get_pftreestate () in
 let pf = proof_of_pftreestate pfs in
 let evc = evc_of_pftreestate pfs in
 let cursor = cursor_of_pftreestate pfs in
 match pf.ref with
  | None -> print_centaur_new_state () | Some (r, spfl) ->
   let sgl = List.map (function p -> p.goal) spfl in
   output_results (ctf_StateMessage !global_request_id) 
      (Some (P_s (translate_state cursor sgl)));;

let print_goal_at_path path =
 try traverse_to (reverse_and_expand [] path);
     let pf = proof_of_pftreestate (get_pftreestate ()) in
     output_results  (ctf_PathGoalMessage ())
       (Some (P_r (translate_goal path pf.goal)))
 with
 | Invalid_argument s -> error "No focused proof (No proof-editing in progress)";;

let print_goal_at_path_req_id path =
 try traverse_to (reverse_and_expand [] path);
     let pf = proof_of_pftreestate (get_pftreestate ()) in
     try
        output_results (ctf_PathGoalReqIdMessage (!global_request_id))
             (Some (P_r (translate_goal path pf.goal)))
     with
     UserError(f,str) ->
         raise (UserError(f,[< (Ast.print_ast  
               (let com =
		 bdize_no_casts true (gLOB pf.goal.hyps) pf.goal.concl in
               let rcom = relativize_cci com in
                 rcom)); str>]))
 with
 | Invalid_argument s -> error "No focused proof (No proof-editing in progress)";;

let print_centaur_killed_state () =
 let pfs = get_pftreestate () in
 let pf = proof_of_pftreestate pfs in
 let cursor = cursor_of_pftreestate pfs in
 output_results (ctf_KilledMessage (!global_request_id))
         (Some (P_rl (translate_node_state cursor pf)));;


(* The rest of the file contains commands that are changed from the plain
   Coq distribution *)

let ctv_SEARCH_LIST = ref ([] : ct_PREMISE list);;

let add_search id_string assumptions cstr =
 ctv_SEARCH_LIST:=
  CT_premise (CT_ident id_string, translate_constr assumptions cstr)::
   !ctv_SEARCH_LIST;;

let make_error_stream node_string =
 [< 'sTR "The syntax of "; 'sTR node_string;
 'sTR " is inconsistent with the vernac interpreter entry" >];;

let ctf_EmptyGoalMessage id =
 [< 'fNL; 'sTR "Empty Goal is a no-op.  Fun oh fun."; 'fNL >];;

(* Our own function for printing the contents of the context *)

let print_check (ast, judg) =
 let {_VAL=value; _TYPE=typ} = judg in
 let value_ct_ast = 
     (try translate_constr (gLOB (initial_sign ())) value 
      with UserError(f,str) ->
           raise(UserError(f, [< Ast.print_ast
			       (let com =
				 bdize_no_casts true (gLOB (initial_sign()))
                                   value in
                               relativize_cci com); 'fNL; str >]))) in
 let type_ct_ast =
     (try translate_constr (gLOB (initial_sign ())) typ
      with UserError(f,str) ->
           raise(UserError(f, [< Ast.print_ast
                            (let com =
			      bdize_no_casts true (gLOB (initial_sign()))
                                value in
                            relativize_cci com); 'fNL; str >]))) in
 ((ctf_SearchResults !global_request_id),
 (Some  (P_pl
  (CT_premises_list
  [CT_coerce_TYPED_FORMULA_to_PREMISE
    (CT_typed_formula(value_ct_ast,type_ct_ast)
    )]))));;

let ct_print_eval ast red_fun hyps judg =
((if refining() then traverse_to []);
let {_VAL=value; _TYPE=typ} = judg in
let nvalue = red_fun value
and ntyp = nf_betaiota typ in
(ctf_SearchResults !global_request_id,
 Some (P_pl
  (CT_premises_list
  [CT_eval_result
    (xlate_formula ast,
    translate_constr (gLOB hyps) nvalue,
    translate_constr (gLOB hyps) ntyp)]))));;

(* This function was stolen from vernacentries.ml *)
let get_evmap_sign args =
  let og = match args with
      [VARG_NUMBER n] ->
        let pftree = get_pftreestate () in
          Some (nth_goal_of_pftreestate n pftree)
    | [] ->
        if refining()
        then
          let pftree = get_pftreestate () in
            try Some (nth_goal_of_pftreestate 1 pftree)
            with UserError _ -> None
        else None
    | _ -> anomaly "malformed optional goal" in
    match og with
        Some goal -> (project goal, pf_hyps goal)
      | _ -> (empty_evd, initial_sign())
;;


let start_pcoq_mode () =
  Errors.eXPLAIN_SYS_EXN:=centaur_explain_exn Errors.explain_user_exn_default;
  Errors.eXPLAIN_USER_EXN:=centaur_explain_exn Errors.explain_user_exn_default;
  overwriting_vinterp_add ("SHOW", 
			   (function
			     | [] ->
				 (function () -> print_centaur_state ())
			     | _ -> errorlabstrm "SHOW" (make_error_stream "SHOW")));

  overwriting_vinterp_add ("StartProof", 
			   (function
			     | (VARG_STRING kind) ::
			       ((VARG_IDENTIFIER s) ::
				((VARG_COMMAND c) :: [])) ->
				  let stre =
				    match kind with
				    | "THEOREM" -> NeverDischarge
				    | "LEMMA" -> make_strength (safe_cdddr (Library.cwd ()))
				    | "FACT" -> make_strength (safe_cdr (Library.cwd ()))
				    | "REMARK" -> make_strength (Library.cwd ())
				    | "DEFINITION" -> NeverDischarge
				    | "LET" -> make_strength (safe_cddr (Library.cwd ()))
				    | "LOCAL" -> make_strength (Library.cwd ())
				    | _ -> errorlabstrm "StartProof" (make_error_stream "StartProof") in
				  (function
				      () -> start_proof (string_of_id s) stre c; print_centaur_state ())
			     | _ -> errorlabstrm "StartProof" (make_error_stream "StartProof")));

  overwriting_vinterp_add ("GOAL", 
			   (function
			     | (VARG_COMMAND c) :: [] ->
				 (function
				     () ->
				       start_proof "Unnamed_thm" NeverDischarge c; print_centaur_state ())
			     | [] ->
				 (function () -> output_results_nl(ctf_EmptyGoalMessage ""))
			     | _ -> errorlabstrm "Goal" (make_error_stream "Goal")));

  vinterp_add ("GOAL_CMD", 
	       (function
		 | (VARG_NUMBERLIST list) ::
		   ((VARG_TACTIC tac) :: []) ->
		     (function () -> solve_proof_command list tac; kill_proof_node list)
		 | _ -> errorlabstrm "GOAL_CMD" (make_error_stream "GOAL_CMD")));

  vinterp_add ("SOLVE_AT", 
	       (function
		 | (VARG_NUMBERLIST list) ::
		   ((VARG_TACTIC tac) :: []) ->
		     (function () -> solve_proof_command list tac; print_centaur_state ())
		 | _ -> errorlabstrm "SOLVE_AT" (make_error_stream "SOLVE_AT")));

  vinterp_add ("KILL_NODE", 
	       (function
		 | (VARG_NUMBERLIST list) :: [] ->
		     (function () -> kill_proof_node list;
		       output_results (ctf_KilledMessage (!global_request_id))
			 (Some (P_s_int (translate_path (List.rev list)))))
		 | _ -> errorlabstrm "KILL_NODE" (make_error_stream "KILL_NODE")));

  vinterp_add ("PRINT_GOAL_AT", 
	       (function
		 | (VARG_NUMBERLIST list) :: [] ->
		     (function () -> print_goal_at_path list)
		 | _ -> errorlabstrm "PRINT_GOAL_AT" (make_error_stream "PRINT_GOAL_AT")));

  vinterp_add ("PRINT_GOAL_AT_REQ_ID", 
	       (function
		 | (VARG_NUMBERLIST list) :: [] ->
		     (function () -> print_goal_at_path_req_id list)
		 | _ -> errorlabstrm "PRINT_GOAL_AT" (make_error_stream "PRINT_GOAL_AT")));

  overwriting_vinterp_add ("BeginSilent", 
			   (function
			     | [] ->
				 (function
				     () ->
				       errorlabstrm "Begin Silent" [< 'sTR "not available in Centaur mode" >])
			     | _ -> errorlabstrm "BeginSilent" (make_error_stream "BeginSilent")));

  overwriting_vinterp_add ("EndSilent", 
			   (function
			     | [] ->
				 (function
				     () ->
				       errorlabstrm "End Silent" [< 'sTR "not available in Centaur mode" >])
			     | _ -> errorlabstrm "EndSilent" (make_error_stream "EndSilent")));

  overwriting_vinterp_add ("SaveNamed", 
			   (function
			     | [] ->
				 (function () -> traverse_to []; save_named true)
			     | _ -> errorlabstrm "SaveNamed" (make_error_stream "SaveNamed")));

  overwriting_vinterp_add ("DefinedNamed", 
			   (function
			     | [] ->
				 (function () -> traverse_to []; save_named false)
			     | _ -> errorlabstrm "DefinedNamed" (make_error_stream "DefinedNamed")));

  overwriting_vinterp_add ("SaveAnonymousThm", 
			   (function
			     | (VARG_IDENTIFIER id) :: [] ->
				 (function () -> traverse_to []; save_anonymous_thm true (string_of_id id))
			     | _ ->
				 errorlabstrm "SaveAnonymousThm" (make_error_stream "SaveAnonymousThm")));

  overwriting_vinterp_add ("SaveAnonymousRmk", 
			   (function
			     | (VARG_IDENTIFIER id) :: [] ->
				 (function
				     () -> traverse_to []; save_anonymous_remark true (string_of_id id))
			     | _ ->
				 errorlabstrm "SaveAnonymousRmk" (make_error_stream "SaveAnonymousRmk")));

  overwriting_vinterp_add ("ABORT", 
			   (function
			     | (VARG_IDENTIFIER id) :: [] ->
				 (function
				     () ->
				       abort_goal (string_of_id id);
				       output_results_nl (ctf_AbortedMessage !global_request_id (string_of_id id)))
			     | [] ->
				 (function
				     () -> abort_cur_goal ();
				       output_results_nl
					 (ctf_AbortedMessage !global_request_id ""))
			     | _ -> errorlabstrm "ABORT" (make_error_stream "ABORT")));

  overwriting_vinterp_add ("SEARCH", 
			   (function
			     | (VARG_IDENTIFIER id) :: [] ->
				 (function () ->
				   ctv_SEARCH_LIST:=[];
				   Pretty.crible add_search id;
				   output_results
				     (ctf_SearchResults !global_request_id)
				     (Some (P_pl (CT_premises_list (List.rev !ctv_SEARCH_LIST)))))
			     | _ -> errorlabstrm "SEARCH" (make_error_stream "SEARCH")));


  overwriting_vinterp_add("PrintOption",
			  (function
			    | [VARG_IDENTIFIER id] ->
				(function () -> 
				  let results = xlate_vernac_list (name_to_ast id) in
				  (output_results [<'fNL; 'sTR "message"; 'fNL; 'sTR "PRINT_VALUE"; 'fNL >]
				   (Some (P_cl results))))
			    | _ -> errorlabstrm "PrintId" (make_error_stream "PrintId")));

  overwriting_vinterp_add ("Check", 
			   (function
			     | (VARG_STRING kind) :: ((VARG_COMMAND c) :: g) ->
				 let (evmap, sign) = get_evmap_sign g in
				 let f =
				   match kind with
				   | "CHECK" -> print_check
				   | "PRINTTYPE" ->
				       errorlabstrm "PrintType" [< 'sTR "Not yet supported in CtCoq" >]
				   | _ -> errorlabstrm "CHECK" (make_error_stream "CHECK") in
				 (function () -> 
				   let a,b = f (c, fconstruct evmap sign c) in
				   output_results a b)
			     | _ -> errorlabstrm "CHECK" (make_error_stream "CHECK")));

  overwriting_vinterp_add("Eval",
			  (function
			    | VARG_TACTIC_ARG(REDEXP(rn,unf)):: VARG_COMMAND c :: g ->
				let (evmap, sign) = get_evmap_sign g in
				let redexp = redexp_of_ast evmap sign (rn, unf) in
				let redfun = ct_print_eval c (reduction_of_redexp redexp evmap) sign in
				fun () -> 
				  let strm, vtp = redfun (fconstruct evmap sign c) in
				  output_results strm vtp
			    | _ -> errorlabstrm "Eval" (make_error_stream "Eval")));

  overwriting_vinterp_add ("Centaur_Reset", 
			   (function
			     | (VARG_IDENTIFIER c) :: [] ->
				 if refining () then output_results (ctf_AbortedAllMessage ()) None; (match string_of_id c with
				 | "CtCoqInitialState" ->
				     (function
					 () ->
					   Pfedit.restore_state "CtCoqInitialState";
					   output_results (ctf_ResetInitialMessage ()) None)
				 | _ ->
				     (function
					 () ->
					   reset_name c;
					   output_results
					     (ctf_ResetIdentMessage !global_request_id (string_of_id c)) None))
			     | _ -> errorlabstrm "Centaur_Reset" (make_error_stream "Centaur_Reset")));;

Vernacentries.add("Comments",
      function l ->
              (fun () -> message ("Comments ok\n")));

Vernacentries.add("CommentsBold",
      function l ->
              (fun () -> message ("CommentsBold ok\n")));

Vernacentries.add("Title",
      function l ->
              (fun () -> message ("Title ok\n")));

Vernacentries.add("Author",
      function l ->
              (fun () -> message ("Author ok\n")));

Vernacentries.add("Note",
      function l ->
              (fun () -> message ("Note ok\n")));

Vernacentries.add("NL",
      function l ->
              (fun () -> message ("Newline ok\n")));;


vinterp_add("START_PCOQ", 
	    (function _ -> 
	      (function () ->
		start_pcoq_mode();
		set_start_marker "CENTAUR_RESERVED_TOKEN_start_command";
		set_end_marker "CENTAUR_RESERVED_TOKEN_end_command";
		raise Vernacinterp.ProtectedLoop)));;

(* the following function determines whether a given ast term represents a
coercion.  If it does, it returns the number of parameters. *)

(* The patterns in this function are inspired by the file
   src/typing/printer.ml, in Coq V6.2 *)

set_coercion_description  defined_as_coercion;;

(* The following function is copied from globpr in env/printer.ml *)
let globcv = function
  | Node(_,"MUTIND", (Path(_,sl,s))::(Num(_,tyi))::_) ->
       string_of_id (id_of_global (MutInd(section_path sl s, tyi)))
  | Node(_,"MUTCONSTRUCT",(Path(_,sl,s))::(Num(_,tyi))::(Num(_,i))::_) ->
       string_of_id
          (id_of_global (MutConstruct((section_path sl s, tyi), i)))
  | _ -> failwith "globcv : unexpected value";;

set_xlate_mut_stuff globcv;;

declare_in_coq();;

