(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                termdn.ml                                 *)
(****************************************************************************)
open More_util;;
open Vectops;;
open Generic;;
open Term;;

(* 
   Discrimination nets of terms.
   See the module dn.ml for further explanations.
   Eduardo (5/8/97)
*)


type lbl =
    TERM of constr
  | DOPER of sorts oper
  | DLAMBDA
;;

type 'a t = (lbl,constr,'a) Dn.t;;
(* existe deja dans term.ml - HH 12-12-97
let rec occur_meta =
function
    DOP0 (Meta _) -> true
  | Rel _ -> false
  | VAR _ -> false
  | DOP0 _ -> false
  | DOP1(_,c) -> occur_meta c
  | DOP2(_,c1,c2) -> occur_meta c1 or occur_meta c2
  | DOPN(_,cl) -> exists_vect occur_meta cl
  | DOPL(_,cl) -> List.exists occur_meta cl
  | DLAM(_,c) -> occur_meta c
  | DLAMV(_,cl) -> exists_vect occur_meta cl
;;
*)

(*If we have: f a b c ..., decomp gives: (f,[a;b;c;...])*)
let decomp = 
 let rec decrec acc = function
    DOPN(AppL,cl) -> decrec (app_tl_vect cl acc) (hd_vect cl)
  | DOP2(Cast,c1,_) -> decrec acc c1
  | c -> (c,acc)
 in decrec []   
;;

let constr_pat_discr t =
    if not(occur_meta t) then None
    else
        match decomp t with
(*        DOPN(Const _,_) as c,l -> Some(TERM c,l)
      | *)
        DOPN(MutInd _,_) as c,l -> Some(TERM c,l)
      | DOPN(MutConstruct _,_) as c,l -> Some(TERM c,l)
      | VAR _ as c,l -> Some(TERM c,l)
      | c -> None
;;

let constr_val_discr t =
    match decomp t with
(*    DOPN(Const _,_) as c,l -> Some(TERM c,l)
  | *)
    DOPN(MutInd _,_) as c,l -> Some(TERM c,l)
  | DOPN(MutConstruct _,_) as c,l -> Some(TERM c,l)
  | VAR _ as c,l -> Some(TERM c,l)
  | c -> None
;;

(* Les deux fonctions suivantes ecrasaient les precedentes, 
   ajout d'un suffixe _nil CP 16/08 *) 

let constr_pat_discr_nil t =
    match constr_pat_discr t with
    None -> None
  | Some (c,_) -> Some(c,[])
;;

let constr_val_discr_nil t =
    match constr_val_discr t with
    None -> None
  | Some (c,_) -> Some(c,[])
;;

let create () = Dn.create constr_pat_discr;;

let add = Dn.add;;
let rmv = Dn.rmv;;

let lookup dn t = Dn.lookup dn constr_val_discr t;;

let app f dn = Dn.app f dn;;

(* $Id: termdn.ml,v 1.10 1999/06/29 07:47:42 loiseleu Exp $ *)
