(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                esyntax.mli                               *)
(****************************************************************************)

open Pp
open Extend


(** Syntax entry tables **)
type frozen_t

(* pretty-printer summary operations *)
val init : unit -> unit
val freeze : unit -> frozen_t
val unfreeze : frozen_t -> unit

(* Search and add a PP rule for an ast in the summary *)
val find_syntax_entry :
  string -> CoqAst.t -> (syntax_entry * Ast.env) option
val add_rule : string -> syntax_entry -> unit
val add_ppobject : (string * syntax_entry list) -> unit

(* Pretty-printing *)

type std_printer = CoqAst.t -> std_ppcmds
type unparsing_subfunction =
    ((string * precedence) * parenRelation) option -> std_printer

(* Module of primitive printers *)
module Ppprim :
  sig
    type t = std_printer -> std_printer
    val add : string * t -> unit
  end

(* Generic printing functions *) 
val token_printer: std_printer -> std_printer
val print_syntax_entry : 
  unparsing_subfunction -> Ast.env -> syntax_entry -> std_ppcmds
val genprint : string -> std_printer -> unparsing_subfunction


(* $Id: esyntax.mli,v 1.3 1999/06/29 07:47:29 loiseleu Exp $ *)
