(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 mavm.ml                                  *)
(****************************************************************************)
open Std;;

type ('a,'b) t = {mutable v : ('a,'b) Avm.t;
                  ord : 'a -> 'a -> int};;
type ('a,'b) frozen_t = ('a,'b) Avm.frozen_t;;

let create ord = {ord = ord ; v = (Avm.create ord : ('a,'b) Avm.t)};;
let empty mlm = mlm.v <- Avm.create mlm.ord;;
let map mlm k = Avm.map mlm.v k;;
let dom mlm = Avm.dom mlm.v;;
let rng mlm = Avm.rng mlm.v;;
let in_dom mlm = Avm.in_dom mlm.v;;
let inv mlm = Avm.inv mlm.v;;
let add mlm p = (mlm.v <- (Avm.add mlm.v p));;
let rmv mlm k = (mlm.v <- (Avm.rmv mlm.v k));;
let remap mlm k v = (mlm.v <- (Avm.remap mlm.v k v));;
let app f mlm = Avm.app f mlm.v;;
let toList mlm = Avm.toList mlm.v;;

let freeze m = Avm.freeze m.v;;
let unfreeze fm m = m.v <- Avm.unfreeze fm m.v;;

(* $Id: mavm.ml,v 1.5 1999/06/29 07:47:18 loiseleu Exp $ *)
