(****************************************************************************)
(*                 The Calculus of Inductive Constructions                  *)
(*                                                                          *)
(*                                Projet Coq                                *)
(*                                                                          *)
(*                     INRIA        LRI-CNRS        ENS-CNRS                *)
(*              Rocquencourt         Orsay          Lyon                    *)
(*                                                                          *)
(*                                 Coq V6.3                                 *)
(*                               July 1st 1999                              *)
(*                                                                          *)
(****************************************************************************)
(*                                 avs.mli                                  *)
(****************************************************************************)
open Std;;

type 'a t;;

val add : 'a t -> 'a -> 'a t;;
val rmv : 'a t -> 'a -> 'a t;;
val memb : 'a t -> 'a -> bool;;
val intersect : 'a t -> 'a t -> 'a t;;
val union : 'a t -> 'a t -> 'a t;;
val diff : 'a t -> 'a t -> 'a t;;
val symdiff : 'a t -> 'a t -> 'a t;;
val subset : 'a t -> 'a t -> bool;;
val equal : 'a t -> 'a t -> bool;;
val mt : 'a t;;
val exists : ('a -> bool) -> 'a t -> bool;;
val toList : 'a t -> 'a list;;
val ofList : 'a list -> 'a t;;
val is_empty : 'a t -> bool;;
val app : ('a -> 'b) -> 'a t -> unit;;

(* $Id: avs.mli,v 1.5 1999/06/29 07:47:14 loiseleu Exp $ *)
