########################################################################
#
# genDefault is a bit of a misnomer, because not only the default
# values are generated, but also the `struct Cmdline' returned to
# main().
#
########################################################################

########################################################################
#
# wrap quotes around a string, if the option type is char*
#
proc cValue {val type} {
  if { $type=="char*" } {
    return "\"$val\""
  } else {
    return $val
  }
}
########################################################################
#
# Generate a default value. If count<=1 for this option, it is the
# value specified in the description file, quoted if necessary. If
# count can be greater 1, it is the name of a variable holding the
# default values.
#
proc genDefaultVal {opt} {
  global D 

  set res {}

  if { $D($opt,cmax) == 1 } {
    if { [info exist D($opt,default)]} {
      append res [cValue [lindex $D($opt,default) 0] $D($opt,type)]
    } else {
      append res "($D($opt,type))0"
    }

  } else {
    ## return a suitable variable name, if we have a default
    if { [info exist D($opt,default)]} {
      append res "$D($opt,name)Default"
    } else {
      append res "($D($opt,type)*)0"
    }

  }
  return $res;
}
########################################################################
#
# Generate C-code for default-arrays. These are used for options
# having an argument count greater than 1.
#
proc genDefaultArrays {} {
  global D L

  set res {}

  foreach opt $L {
    if { ![info exist D($opt,default)] } continue
    #if { ![info exist D($opt,cmax)] } continue
    if { ![Infty $D($opt,cmax)] && $D($opt,cmax) <= 1 } continue

    append res \
	"static $D($opt,type) $D($opt,name)Default\[\] = \{"

    set comma {}
    foreach x $D($opt,default) {
      append res $comma [cValue $x $D($opt,type)]
      set comma ", "
    }
    append res "\};\n"
  }
  return $res
}
########################################################################
#
# generate the static structure a pointer to which is returned by the
# command line parser to main().
#
proc genDefault {} {
  global D L

  set res [genDefaultArrays]
  append res "\nstatic Cmdline cmd = \{\n"
  
  set comma {}
  foreach opt $L {
    append res $comma \
	"  /***** $opt: $D($opt,usage) */\n"\
	"  /* $D($opt,name)P = */ "
    if {[info exist D($opt,default)] } {
      append res TRUE
    } else {
      append res FALSE
    }
    set comma ",\n"

    if { $D($opt,type)=="flag" } continue

    append res \
	",\n  /* $D($opt,name) = */ [genDefaultVal $opt]"\
	",\n  /* $D($opt,name)C = */ "
    if { ![info exist D($opt,default)] } {
      append res 0
    } else {
      append res [llength $D($opt,default)]
    }
  }

  append res ",\n  /***** uninterpreted rest of command line */"
  append res "\n  /* argc = */ 0"
  append res ",\n  /* argv = */ (char**)0"

  ## the whole command line concatenated
  global argvString
  if [info exist argvString] {
    append res ",\n  /***** the original command line concatenated */"
    append res "\n  /* $argvString = */ NULL"
  }
  append res "\n\};\n"

  
  return $res
}
