
#define SREAL
#include "atlas_misc.h"
#include "atlas_level1.h"
#include "cblas.h"

void cblas_srot(const int N, float *X, const int incX, 
                float *Y, const int incY, const float c, const float s)
{
   if (incX < 0)
   {
      if (incY < 0) ATL_srot(N, X, -incX, Y, -incY, c, s);
      else ATL_srot(N, X+((1-N)*incX), incX, Y, incY, c, s);
   }
   else if (incY < 0) 
      ATL_srot(N, X+((N-1)*incX), -incX, Y, -incY, c, s);
   else ATL_srot(N, X, incX, Y, incY, c, s);
}
