#include<stdio.h>
#include<stdlib.h>
#include<assert.h>

void PutInstLogFile(FILE *fp, int muladd, int lat, int nb,
                    int mu, int nu, int ku, int ForceFetch,
                    int ifetch, int nfetch, double mflop)
{
   fprintf(fp, "MULADD  LAT  NB  MU  NU  KU  FFTCH  IFTCH  NFTCH    MFLOP\n");
   fprintf(fp, "%6d  %3d %3d %3d %3d %3d  %5d  %5d  %5d  %7.2lf\n",
           muladd, lat, nb, mu, nu, ku, ForceFetch, ifetch, nfetch, mflop);
}
void PutInstLogFile1(char *fnam, char pre, int muladd, int lat, int nb,
                    int mu, int nu, int ku, int ForceFetch,
                    int ifetch, int nfetch, double mflop)
{
   FILE *fp;

   fp = fopen(fnam, "w");
   assert(fp);
   PutInstLogFile(fp, muladd, lat, nb, mu, nu, ku, ForceFetch, ifetch, nfetch,
                  mflop);
   fclose(fp);
}
void GetInstLogFile(char *nam, char pre, int *muladd, int *lat, int *nb,
                    int *mu, int *nu, int *ku, int *ForceFetch,
                    int *ifetch, int *nfetch, double *mflop)
{
   char ln[128];
   FILE *fp;

   fp = fopen(nam, "r");
   if (fp == NULL) fprintf(stderr, "file %s not found!!\n\n", nam);
   assert(fp);
   fgets(ln, 128, fp);
   fscanf(fp, " %d  %d %d %d %d %d %d %d %d %lf\n",
          muladd, lat, nb, mu, nu, ku, ForceFetch, ifetch, nfetch, mflop);
   fclose(fp);
}

main(int nargs, char **args)
{
   int i, muladd, lat, nb, mu, nu, ku, ffetch, ifetch, nfetch;
   double mf;

   for (i=1; i < nargs; i++)
   {
      GetInstLogFile(args[i], args[i][0], &muladd, &lat, &nb, &mu, &nu, &ku, 
                     &ffetch, &ifetch, &nfetch, &mf);
      mf = -mf;
      PutInstLogFile1(args[i], args[i][0], muladd, lat, nb, mu, nu, ku, 
                      ffetch, ifetch, nfetch, mf);
   }
   exit(0);
}
