// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: basic.cc,v 1.5 1998/09/07 05:28:40 jgg Exp $
/* ######################################################################

   BasicWidget - Base class for many of the widgets

   This is a very simple widget, just does some draw commands.. 
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/basic.h"
#endif
#include <deity/basic.h>
#include <deity/utils.h>

#include <math.h>
									/*}}}*/

// BasicWidget::BasicWidget - Constructor				/*{{{*/
// ---------------------------------------------------------------------
/* */
BasicWidget::BasicWidget(Widget *Parent) : Widget(Parent),
                 iFont("helvetica",120), iMargins(0,0)
{
   iBackground = Wc_LightGray;
   iBorderUl = Wc_White;
   iBorderLr = Wc_Gray;
   iColor = Wc_Black;
   iBorderWidth = 1;
   iBFlags = 0;
   BorderX = BorderY = iBorderWidth;
}
									/*}}}*/
// BasicWidget::BasicRender - Fill the background and draw a border	/*{{{*/
// ---------------------------------------------------------------------
/* The last thing this rountine will do is configure the GC for the proper
   font and colours. It does not push a clipping region onto the clipping 
   stack, derived widgets will have to deal with that. */
void BasicWidget::BasicRender(CombinedGC &GC,bool Clear)
{
   // Render a nice 3d box of variable width
   if (GC.IsGraphic() == true)
   {
      int Width = iBorderWidth;
      if (IsBFlag(EtchBorder) == true)
	 Width = (int)ceil(iBorderWidth/2.0);
	 
      if (Clear == true && IsBFlag(EtchBorder) == false)
	 GC.gGC->Box3d(Rect(0,0,Pos.w,Pos.h),iBorderUl,iBorderLr,
		       iBackground,Width);
      else
	 GC.gGC->Box3d(Rect(0,0,Pos.w,Pos.h),iBorderUl,iBorderLr,
		       Wc_None,Width);
      
      if (IsBFlag(EtchBorder) == true)
      {
	 int NWidth = iBorderWidth - Width;
	 
	 if (Clear == true)
	    GC.gGC->Box3d(Rect(Width,Width,Pos.w - 2*Width,Pos.h-2*Width),
			  iBorderLr,iBorderUl,iBackground,NWidth);
	 else
	    GC.gGC->Box3d(Rect(Width,Width,Pos.w - 2*Width,Pos.h-2*Width),
			  iBorderLr,iBorderUl,Wc_None,NWidth);
      }
   }
   
   // Render whatever box the text impl can give us
   if (GC.IsText() != 0)
   {
      if (Clear == true)
      {
	 GC.tGC->SetColor(iBackground);
	 GC.tGC->Fill(Rect(0,0,Pos.w,Pos.h));
      }
      
      GC.tGC->SetColor(iBorderLr);
      GC.tGC->Background(iBackground);
      if (iBorderWidth > 0)
	 GC.tGC->Box(Rect(0,0,Pos.w,Pos.h));
   }   
   
   // Set the default attributes
   GC->SetFont(iFont);
   GC->SetColor(iColor);
   GC->Background(iBackground);
}
									/*}}}*/
// BasicWidget::Foreground - Change the foreground colour		/*{{{*/
// ---------------------------------------------------------------------
/* */
void BasicWidget::Foreground(Color C)
{
   iColor = C;
   Damage();
}
									/*}}}*/
// BasicWidget::Background - Change the background colour		/*{{{*/
// ---------------------------------------------------------------------
/* */
void BasicWidget::Background(Color C)
{
   iBackground = C;
   Damage();
}
									/*}}}*/
// BasicWidget::BorderWidth - Set the border width			/*{{{*/
// ---------------------------------------------------------------------
/* If the existing directional width is larger than the previously set 
   width then that difference is kept during resizing. */
void BasicWidget::BorderWidth(unsigned long Width)
{
   if (BorderX <= (signed)iBorderWidth)
      BorderX = Width;
   else 
      BorderX -= iBorderWidth - Width;
   
   if (BorderY <= (signed)iBorderWidth)
      BorderY = Width;
   else 
      BorderY -= iBorderWidth - Width;
   iBorderWidth = Width;
   Damage();
}
									/*}}}*/
// BasicWidget::Margins - Set the margin widths				/*{{{*/
// ---------------------------------------------------------------------
/* */
void BasicWidget::Margins(Point Width)
{
   iMargins = Width;
   Damage();
}
									/*}}}*/
// BasicWidget::IdealSize - Return the size of all children		/*{{{*/
// ---------------------------------------------------------------------
/* */
Point BasicWidget::IdealSize()
{
   Point P = ChildrenExtent(this);
   P.x += 2*iMargins.x;
   P.y += 2*iMargins.y;
   return P;
}
									/*}}}*/

